/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSubscriptionResponse extends DataZoneResponse implements
        ToCopyableBuilder<CancelSubscriptionResponse.Builder, CancelSubscriptionResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CancelSubscriptionResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(CancelSubscriptionResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CancelSubscriptionResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CancelSubscriptionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Boolean> RETAIN_PERMISSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("retainPermissions").getter(getter(CancelSubscriptionResponse::retainPermissions))
            .setter(setter(Builder::retainPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retainPermissions").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CancelSubscriptionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<SubscribedListing> SUBSCRIBED_LISTING_FIELD = SdkField
            .<SubscribedListing> builder(MarshallingType.SDK_POJO).memberName("subscribedListing")
            .getter(getter(CancelSubscriptionResponse::subscribedListing)).setter(setter(Builder::subscribedListing))
            .constructor(SubscribedListing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedListing").build()).build();

    private static final SdkField<SubscribedPrincipal> SUBSCRIBED_PRINCIPAL_FIELD = SdkField
            .<SubscribedPrincipal> builder(MarshallingType.SDK_POJO).memberName("subscribedPrincipal")
            .getter(getter(CancelSubscriptionResponse::subscribedPrincipal)).setter(setter(Builder::subscribedPrincipal))
            .constructor(SubscribedPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedPrincipal").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionRequestId").getter(getter(CancelSubscriptionResponse::subscriptionRequestId))
            .setter(setter(Builder::subscriptionRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionRequestId").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(CancelSubscriptionResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(CancelSubscriptionResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DOMAIN_ID_FIELD, ID_FIELD, RETAIN_PERMISSIONS_FIELD, STATUS_FIELD, SUBSCRIBED_LISTING_FIELD,
            SUBSCRIBED_PRINCIPAL_FIELD, SUBSCRIPTION_REQUEST_ID_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private final Instant createdAt;

    private final String createdBy;

    private final String domainId;

    private final String id;

    private final Boolean retainPermissions;

    private final String status;

    private final SubscribedListing subscribedListing;

    private final SubscribedPrincipal subscribedPrincipal;

    private final String subscriptionRequestId;

    private final Instant updatedAt;

    private final String updatedBy;

    private CancelSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.retainPermissions = builder.retainPermissions;
        this.status = builder.status;
        this.subscribedListing = builder.subscribedListing;
        this.subscribedPrincipal = builder.subscribedPrincipal;
        this.subscriptionRequestId = builder.subscriptionRequestId;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The timestamp that specifies when the request to cancel the subscription was created.
     * </p>
     * 
     * @return The timestamp that specifies when the request to cancel the subscription was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies the Amazon DataZone user who is cancelling the subscription.
     * </p>
     * 
     * @return Specifies the Amazon DataZone user who is cancelling the subscription.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The unique identifier of the Amazon DataZone domain where the subscription is being cancelled.
     * </p>
     * 
     * @return The unique identifier of the Amazon DataZone domain where the subscription is being cancelled.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of the subscription.
     * </p>
     * 
     * @return The identifier of the subscription.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Specifies whether the permissions to the asset are retained after the subscription is cancelled.
     * </p>
     * 
     * @return Specifies whether the permissions to the asset are retained after the subscription is cancelled.
     */
    public final Boolean retainPermissions() {
        return retainPermissions;
    }

    /**
     * <p>
     * The status of the request to cancel the subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request to cancel the subscription.
     * @see SubscriptionStatus
     */
    public final SubscriptionStatus status() {
        return SubscriptionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request to cancel the subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request to cancel the subscription.
     * @see SubscriptionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The asset to which a subscription is being cancelled.
     * </p>
     * 
     * @return The asset to which a subscription is being cancelled.
     */
    public final SubscribedListing subscribedListing() {
        return subscribedListing;
    }

    /**
     * <p>
     * The Amazon DataZone user who is made a subscriber to the specified asset by the subscription that is being
     * cancelled.
     * </p>
     * 
     * @return The Amazon DataZone user who is made a subscriber to the specified asset by the subscription that is
     *         being cancelled.
     */
    public final SubscribedPrincipal subscribedPrincipal() {
        return subscribedPrincipal;
    }

    /**
     * <p>
     * The unique ID of the subscripton request for the subscription that is being cancelled.
     * </p>
     * 
     * @return The unique ID of the subscripton request for the subscription that is being cancelled.
     */
    public final String subscriptionRequestId() {
        return subscriptionRequestId;
    }

    /**
     * <p>
     * The timestamp that specifies when the subscription was cancelled.
     * </p>
     * 
     * @return The timestamp that specifies when the subscription was cancelled.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon DataZone user that cancelled the subscription.
     * </p>
     * 
     * @return The Amazon DataZone user that cancelled the subscription.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(retainPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedListing());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSubscriptionResponse)) {
            return false;
        }
        CancelSubscriptionResponse other = (CancelSubscriptionResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(id(), other.id())
                && Objects.equals(retainPermissions(), other.retainPermissions())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(subscribedListing(), other.subscribedListing())
                && Objects.equals(subscribedPrincipal(), other.subscribedPrincipal())
                && Objects.equals(subscriptionRequestId(), other.subscriptionRequestId())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelSubscriptionResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DomainId", domainId()).add("Id", id()).add("RetainPermissions", retainPermissions())
                .add("Status", statusAsString()).add("SubscribedListing", subscribedListing())
                .add("SubscribedPrincipal", subscribedPrincipal()).add("SubscriptionRequestId", subscriptionRequestId())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "retainPermissions":
            return Optional.ofNullable(clazz.cast(retainPermissions()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subscribedListing":
            return Optional.ofNullable(clazz.cast(subscribedListing()));
        case "subscribedPrincipal":
            return Optional.ofNullable(clazz.cast(subscribedPrincipal()));
        case "subscriptionRequestId":
            return Optional.ofNullable(clazz.cast(subscriptionRequestId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSubscriptionResponse, T> g) {
        return obj -> g.apply((CancelSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelSubscriptionResponse> {
        /**
         * <p>
         * The timestamp that specifies when the request to cancel the subscription was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp that specifies when the request to cancel the subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies the Amazon DataZone user who is cancelling the subscription.
         * </p>
         * 
         * @param createdBy
         *        Specifies the Amazon DataZone user who is cancelling the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The unique identifier of the Amazon DataZone domain where the subscription is being cancelled.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Amazon DataZone domain where the subscription is being cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of the subscription.
         * </p>
         * 
         * @param id
         *        The identifier of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies whether the permissions to the asset are retained after the subscription is cancelled.
         * </p>
         * 
         * @param retainPermissions
         *        Specifies whether the permissions to the asset are retained after the subscription is cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainPermissions(Boolean retainPermissions);

        /**
         * <p>
         * The status of the request to cancel the subscription.
         * </p>
         * 
         * @param status
         *        The status of the request to cancel the subscription.
         * @see SubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request to cancel the subscription.
         * </p>
         * 
         * @param status
         *        The status of the request to cancel the subscription.
         * @see SubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionStatus
         */
        Builder status(SubscriptionStatus status);

        /**
         * <p>
         * The asset to which a subscription is being cancelled.
         * </p>
         * 
         * @param subscribedListing
         *        The asset to which a subscription is being cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedListing(SubscribedListing subscribedListing);

        /**
         * <p>
         * The asset to which a subscription is being cancelled.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedListing.Builder} avoiding the
         * need to create one manually via {@link SubscribedListing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedListing.Builder#build()} is called immediately and its
         * result is passed to {@link #subscribedListing(SubscribedListing)}.
         * 
         * @param subscribedListing
         *        a consumer that will call methods on {@link SubscribedListing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedListing(SubscribedListing)
         */
        default Builder subscribedListing(Consumer<SubscribedListing.Builder> subscribedListing) {
            return subscribedListing(SubscribedListing.builder().applyMutation(subscribedListing).build());
        }

        /**
         * <p>
         * The Amazon DataZone user who is made a subscriber to the specified asset by the subscription that is being
         * cancelled.
         * </p>
         * 
         * @param subscribedPrincipal
         *        The Amazon DataZone user who is made a subscriber to the specified asset by the subscription that is
         *        being cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedPrincipal(SubscribedPrincipal subscribedPrincipal);

        /**
         * <p>
         * The Amazon DataZone user who is made a subscriber to the specified asset by the subscription that is being
         * cancelled.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedPrincipal.Builder} avoiding the
         * need to create one manually via {@link SubscribedPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedPrincipal.Builder#build()} is called immediately and
         * its result is passed to {@link #subscribedPrincipal(SubscribedPrincipal)}.
         * 
         * @param subscribedPrincipal
         *        a consumer that will call methods on {@link SubscribedPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedPrincipal(SubscribedPrincipal)
         */
        default Builder subscribedPrincipal(Consumer<SubscribedPrincipal.Builder> subscribedPrincipal) {
            return subscribedPrincipal(SubscribedPrincipal.builder().applyMutation(subscribedPrincipal).build());
        }

        /**
         * <p>
         * The unique ID of the subscripton request for the subscription that is being cancelled.
         * </p>
         * 
         * @param subscriptionRequestId
         *        The unique ID of the subscripton request for the subscription that is being cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionRequestId(String subscriptionRequestId);

        /**
         * <p>
         * The timestamp that specifies when the subscription was cancelled.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp that specifies when the subscription was cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon DataZone user that cancelled the subscription.
         * </p>
         * 
         * @param updatedBy
         *        The Amazon DataZone user that cancelled the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String domainId;

        private String id;

        private Boolean retainPermissions;

        private String status;

        private SubscribedListing subscribedListing;

        private SubscribedPrincipal subscribedPrincipal;

        private String subscriptionRequestId;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSubscriptionResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            domainId(model.domainId);
            id(model.id);
            retainPermissions(model.retainPermissions);
            status(model.status);
            subscribedListing(model.subscribedListing);
            subscribedPrincipal(model.subscribedPrincipal);
            subscriptionRequestId(model.subscriptionRequestId);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getRetainPermissions() {
            return retainPermissions;
        }

        public final void setRetainPermissions(Boolean retainPermissions) {
            this.retainPermissions = retainPermissions;
        }

        @Override
        public final Builder retainPermissions(Boolean retainPermissions) {
            this.retainPermissions = retainPermissions;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SubscribedListing.Builder getSubscribedListing() {
            return subscribedListing != null ? subscribedListing.toBuilder() : null;
        }

        public final void setSubscribedListing(SubscribedListing.BuilderImpl subscribedListing) {
            this.subscribedListing = subscribedListing != null ? subscribedListing.build() : null;
        }

        @Override
        public final Builder subscribedListing(SubscribedListing subscribedListing) {
            this.subscribedListing = subscribedListing;
            return this;
        }

        public final SubscribedPrincipal.Builder getSubscribedPrincipal() {
            return subscribedPrincipal != null ? subscribedPrincipal.toBuilder() : null;
        }

        public final void setSubscribedPrincipal(SubscribedPrincipal.BuilderImpl subscribedPrincipal) {
            this.subscribedPrincipal = subscribedPrincipal != null ? subscribedPrincipal.build() : null;
        }

        @Override
        public final Builder subscribedPrincipal(SubscribedPrincipal subscribedPrincipal) {
            this.subscribedPrincipal = subscribedPrincipal;
            return this;
        }

        public final String getSubscriptionRequestId() {
            return subscriptionRequestId;
        }

        public final void setSubscriptionRequestId(String subscriptionRequestId) {
            this.subscriptionRequestId = subscriptionRequestId;
        }

        @Override
        public final Builder subscriptionRequestId(String subscriptionRequestId) {
            this.subscriptionRequestId = subscriptionRequestId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public CancelSubscriptionResponse build() {
            return new CancelSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
