/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ManifestConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ManifestConfig> {
    private static final SdkField<String> MANIFEST_OBJECT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestObjectPath").getter(S3ManifestConfig.getter(S3ManifestConfig::manifestObjectPath)).setter(S3ManifestConfig.setter(Builder::manifestObjectPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestObjectPath").build()}).build();
    private static final SdkField<String> BUCKET_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketAccessRoleArn").getter(S3ManifestConfig.getter(S3ManifestConfig::bucketAccessRoleArn)).setter(S3ManifestConfig.setter(Builder::bucketAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccessRoleArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketArn").getter(S3ManifestConfig.getter(S3ManifestConfig::s3BucketArn)).setter(S3ManifestConfig.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()}).build();
    private static final SdkField<String> MANIFEST_OBJECT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestObjectVersionId").getter(S3ManifestConfig.getter(S3ManifestConfig::manifestObjectVersionId)).setter(S3ManifestConfig.setter(Builder::manifestObjectVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestObjectVersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_OBJECT_PATH_FIELD, BUCKET_ACCESS_ROLE_ARN_FIELD, S3_BUCKET_ARN_FIELD, MANIFEST_OBJECT_VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ManifestObjectPath", MANIFEST_OBJECT_PATH_FIELD);
            this.put("BucketAccessRoleArn", BUCKET_ACCESS_ROLE_ARN_FIELD);
            this.put("S3BucketArn", S3_BUCKET_ARN_FIELD);
            this.put("ManifestObjectVersionId", MANIFEST_OBJECT_VERSION_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String manifestObjectPath;
    private final String bucketAccessRoleArn;
    private final String s3BucketArn;
    private final String manifestObjectVersionId;

    private S3ManifestConfig(BuilderImpl builder) {
        this.manifestObjectPath = builder.manifestObjectPath;
        this.bucketAccessRoleArn = builder.bucketAccessRoleArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.manifestObjectVersionId = builder.manifestObjectVersionId;
    }

    public final String manifestObjectPath() {
        return this.manifestObjectPath;
    }

    public final String bucketAccessRoleArn() {
        return this.bucketAccessRoleArn;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final String manifestObjectVersionId() {
        return this.manifestObjectVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestObjectPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestObjectVersionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ManifestConfig)) {
            return false;
        }
        S3ManifestConfig other = (S3ManifestConfig)obj;
        return Objects.equals(this.manifestObjectPath(), other.manifestObjectPath()) && Objects.equals(this.bucketAccessRoleArn(), other.bucketAccessRoleArn()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.manifestObjectVersionId(), other.manifestObjectVersionId());
    }

    public final String toString() {
        return ToString.builder((String)"S3ManifestConfig").add("ManifestObjectPath", (Object)this.manifestObjectPath()).add("BucketAccessRoleArn", (Object)this.bucketAccessRoleArn()).add("S3BucketArn", (Object)this.s3BucketArn()).add("ManifestObjectVersionId", (Object)this.manifestObjectVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestObjectPath": {
                return Optional.ofNullable(clazz.cast(this.manifestObjectPath()));
            }
            case "BucketAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.bucketAccessRoleArn()));
            }
            case "S3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "ManifestObjectVersionId": {
                return Optional.ofNullable(clazz.cast(this.manifestObjectVersionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3ManifestConfig, T> g) {
        return obj -> g.apply((S3ManifestConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestObjectPath;
        private String bucketAccessRoleArn;
        private String s3BucketArn;
        private String manifestObjectVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ManifestConfig model) {
            this.manifestObjectPath(model.manifestObjectPath);
            this.bucketAccessRoleArn(model.bucketAccessRoleArn);
            this.s3BucketArn(model.s3BucketArn);
            this.manifestObjectVersionId(model.manifestObjectVersionId);
        }

        public final String getManifestObjectPath() {
            return this.manifestObjectPath;
        }

        public final void setManifestObjectPath(String manifestObjectPath) {
            this.manifestObjectPath = manifestObjectPath;
        }

        @Override
        public final Builder manifestObjectPath(String manifestObjectPath) {
            this.manifestObjectPath = manifestObjectPath;
            return this;
        }

        public final String getBucketAccessRoleArn() {
            return this.bucketAccessRoleArn;
        }

        public final void setBucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
        }

        @Override
        public final Builder bucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
            return this;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getManifestObjectVersionId() {
            return this.manifestObjectVersionId;
        }

        public final void setManifestObjectVersionId(String manifestObjectVersionId) {
            this.manifestObjectVersionId = manifestObjectVersionId;
        }

        @Override
        public final Builder manifestObjectVersionId(String manifestObjectVersionId) {
            this.manifestObjectVersionId = manifestObjectVersionId;
            return this;
        }

        public S3ManifestConfig build() {
            return new S3ManifestConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ManifestConfig> {
        public Builder manifestObjectPath(String var1);

        public Builder bucketAccessRoleArn(String var1);

        public Builder s3BucketArn(String var1);

        public Builder manifestObjectVersionId(String var1);
    }
}

