/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.DataCatalogOutput;
import software.amazon.awssdk.services.databrew.model.DataCatalogOutputListCopier;
import software.amazon.awssdk.services.databrew.model.DatabaseOutput;
import software.amazon.awssdk.services.databrew.model.DatabaseOutputListCopier;
import software.amazon.awssdk.services.databrew.model.JobRunState;
import software.amazon.awssdk.services.databrew.model.JobSample;
import software.amazon.awssdk.services.databrew.model.LogSubscription;
import software.amazon.awssdk.services.databrew.model.Output;
import software.amazon.awssdk.services.databrew.model.OutputListCopier;
import software.amazon.awssdk.services.databrew.model.RecipeReference;
import software.amazon.awssdk.services.databrew.model.ValidationConfiguration;
import software.amazon.awssdk.services.databrew.model.ValidationConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRun> {
    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Attempt").getter(JobRun.getter(JobRun::attempt)).setter(JobRun.setter(Builder::attempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attempt").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(JobRun.getter(JobRun::completedOn)).setter(JobRun.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(JobRun.getter(JobRun::datasetName)).setter(JobRun.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(JobRun.getter(JobRun::errorMessage)).setter(JobRun.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionTime").getter(JobRun.getter(JobRun::executionTime)).setter(JobRun.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(JobRun.getter(JobRun::jobName)).setter(JobRun.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(JobRun.getter(JobRun::runId)).setter(JobRun.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(JobRun.getter(JobRun::stateAsString)).setter(JobRun.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogSubscription").getter(JobRun.getter(JobRun::logSubscriptionAsString)).setter(JobRun.setter(Builder::logSubscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupName").getter(JobRun.getter(JobRun::logGroupName)).setter(JobRun.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(JobRun.getter(JobRun::outputs)).setter(JobRun.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataCatalogOutput>> DATA_CATALOG_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataCatalogOutputs").getter(JobRun.getter(JobRun::dataCatalogOutputs)).setter(JobRun.setter(Builder::dataCatalogOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataCatalogOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DatabaseOutput>> DATABASE_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatabaseOutputs").getter(JobRun.getter(JobRun::databaseOutputs)).setter(JobRun.setter(Builder::databaseOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatabaseOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecipeReference").getter(JobRun.getter(JobRun::recipeReference)).setter(JobRun.setter(Builder::recipeReference)).constructor(RecipeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartedBy").getter(JobRun.getter(JobRun::startedBy)).setter(JobRun.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBy").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(JobRun.getter(JobRun::startedOn)).setter(JobRun.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<JobSample> JOB_SAMPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobSample").getter(JobRun.getter(JobRun::jobSample)).setter(JobRun.setter(Builder::jobSample)).constructor(JobSample::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSample").build()}).build();
    private static final SdkField<List<ValidationConfiguration>> VALIDATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationConfigurations").getter(JobRun.getter(JobRun::validationConfigurations)).setter(JobRun.setter(Builder::validationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPT_FIELD, COMPLETED_ON_FIELD, DATASET_NAME_FIELD, ERROR_MESSAGE_FIELD, EXECUTION_TIME_FIELD, JOB_NAME_FIELD, RUN_ID_FIELD, STATE_FIELD, LOG_SUBSCRIPTION_FIELD, LOG_GROUP_NAME_FIELD, OUTPUTS_FIELD, DATA_CATALOG_OUTPUTS_FIELD, DATABASE_OUTPUTS_FIELD, RECIPE_REFERENCE_FIELD, STARTED_BY_FIELD, STARTED_ON_FIELD, JOB_SAMPLE_FIELD, VALIDATION_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer attempt;
    private final Instant completedOn;
    private final String datasetName;
    private final String errorMessage;
    private final Integer executionTime;
    private final String jobName;
    private final String runId;
    private final String state;
    private final String logSubscription;
    private final String logGroupName;
    private final List<Output> outputs;
    private final List<DataCatalogOutput> dataCatalogOutputs;
    private final List<DatabaseOutput> databaseOutputs;
    private final RecipeReference recipeReference;
    private final String startedBy;
    private final Instant startedOn;
    private final JobSample jobSample;
    private final List<ValidationConfiguration> validationConfigurations;

    private JobRun(BuilderImpl builder) {
        this.attempt = builder.attempt;
        this.completedOn = builder.completedOn;
        this.datasetName = builder.datasetName;
        this.errorMessage = builder.errorMessage;
        this.executionTime = builder.executionTime;
        this.jobName = builder.jobName;
        this.runId = builder.runId;
        this.state = builder.state;
        this.logSubscription = builder.logSubscription;
        this.logGroupName = builder.logGroupName;
        this.outputs = builder.outputs;
        this.dataCatalogOutputs = builder.dataCatalogOutputs;
        this.databaseOutputs = builder.databaseOutputs;
        this.recipeReference = builder.recipeReference;
        this.startedBy = builder.startedBy;
        this.startedOn = builder.startedOn;
        this.jobSample = builder.jobSample;
        this.validationConfigurations = builder.validationConfigurations;
    }

    public final Integer attempt() {
        return this.attempt;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Integer executionTime() {
        return this.executionTime;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String runId() {
        return this.runId;
    }

    public final JobRunState state() {
        return JobRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(this.logSubscription);
    }

    public final String logSubscriptionAsString() {
        return this.logSubscription;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<Output> outputs() {
        return this.outputs;
    }

    public final boolean hasDataCatalogOutputs() {
        return this.dataCatalogOutputs != null && !(this.dataCatalogOutputs instanceof SdkAutoConstructList);
    }

    public final List<DataCatalogOutput> dataCatalogOutputs() {
        return this.dataCatalogOutputs;
    }

    public final boolean hasDatabaseOutputs() {
        return this.databaseOutputs != null && !(this.databaseOutputs instanceof SdkAutoConstructList);
    }

    public final List<DatabaseOutput> databaseOutputs() {
        return this.databaseOutputs;
    }

    public final RecipeReference recipeReference() {
        return this.recipeReference;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final JobSample jobSample() {
        return this.jobSample;
    }

    public final boolean hasValidationConfigurations() {
        return this.validationConfigurations != null && !(this.validationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ValidationConfiguration> validationConfigurations() {
        return this.validationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataCatalogOutputs() ? this.dataCatalogOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseOutputs() ? this.databaseOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobSample());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationConfigurations() ? this.validationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)obj;
        return Objects.equals(this.attempt(), other.attempt()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.executionTime(), other.executionTime()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.logSubscriptionAsString(), other.logSubscriptionAsString()) && Objects.equals(this.logGroupName(), other.logGroupName()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && this.hasDataCatalogOutputs() == other.hasDataCatalogOutputs() && Objects.equals(this.dataCatalogOutputs(), other.dataCatalogOutputs()) && this.hasDatabaseOutputs() == other.hasDatabaseOutputs() && Objects.equals(this.databaseOutputs(), other.databaseOutputs()) && Objects.equals(this.recipeReference(), other.recipeReference()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.jobSample(), other.jobSample()) && this.hasValidationConfigurations() == other.hasValidationConfigurations() && Objects.equals(this.validationConfigurations(), other.validationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"JobRun").add("Attempt", (Object)this.attempt()).add("CompletedOn", (Object)this.completedOn()).add("DatasetName", (Object)this.datasetName()).add("ErrorMessage", (Object)this.errorMessage()).add("ExecutionTime", (Object)this.executionTime()).add("JobName", (Object)this.jobName()).add("RunId", (Object)this.runId()).add("State", (Object)this.stateAsString()).add("LogSubscription", (Object)this.logSubscriptionAsString()).add("LogGroupName", (Object)this.logGroupName()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("DataCatalogOutputs", this.hasDataCatalogOutputs() ? this.dataCatalogOutputs() : null).add("DatabaseOutputs", this.hasDatabaseOutputs() ? this.databaseOutputs() : null).add("RecipeReference", (Object)this.recipeReference()).add("StartedBy", (Object)this.startedBy()).add("StartedOn", (Object)this.startedOn()).add("JobSample", (Object)this.jobSample()).add("ValidationConfigurations", this.hasValidationConfigurations() ? this.validationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attempt": {
                return Optional.ofNullable(clazz.cast(this.attempt()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "LogSubscription": {
                return Optional.ofNullable(clazz.cast(this.logSubscriptionAsString()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "DataCatalogOutputs": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogOutputs()));
            }
            case "DatabaseOutputs": {
                return Optional.ofNullable(clazz.cast(this.databaseOutputs()));
            }
            case "RecipeReference": {
                return Optional.ofNullable(clazz.cast(this.recipeReference()));
            }
            case "StartedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "JobSample": {
                return Optional.ofNullable(clazz.cast(this.jobSample()));
            }
            case "ValidationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.validationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobRun, T> g) {
        return obj -> g.apply((JobRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer attempt;
        private Instant completedOn;
        private String datasetName;
        private String errorMessage;
        private Integer executionTime;
        private String jobName;
        private String runId;
        private String state;
        private String logSubscription;
        private String logGroupName;
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<DataCatalogOutput> dataCatalogOutputs = DefaultSdkAutoConstructList.getInstance();
        private List<DatabaseOutput> databaseOutputs = DefaultSdkAutoConstructList.getInstance();
        private RecipeReference recipeReference;
        private String startedBy;
        private Instant startedOn;
        private JobSample jobSample;
        private List<ValidationConfiguration> validationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobRun model) {
            this.attempt(model.attempt);
            this.completedOn(model.completedOn);
            this.datasetName(model.datasetName);
            this.errorMessage(model.errorMessage);
            this.executionTime(model.executionTime);
            this.jobName(model.jobName);
            this.runId(model.runId);
            this.state(model.state);
            this.logSubscription(model.logSubscription);
            this.logGroupName(model.logGroupName);
            this.outputs(model.outputs);
            this.dataCatalogOutputs(model.dataCatalogOutputs);
            this.databaseOutputs(model.databaseOutputs);
            this.recipeReference(model.recipeReference);
            this.startedBy(model.startedBy);
            this.startedOn(model.startedOn);
            this.jobSample(model.jobSample);
            this.validationConfigurations(model.validationConfigurations);
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Integer getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getLogSubscription() {
            return this.logSubscription;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataCatalogOutput.Builder> getDataCatalogOutputs() {
            List<DataCatalogOutput.Builder> result = DataCatalogOutputListCopier.copyToBuilder(this.dataCatalogOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataCatalogOutputs(Collection<DataCatalogOutput.BuilderImpl> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copyFromBuilder(dataCatalogOutputs);
        }

        @Override
        public final Builder dataCatalogOutputs(Collection<DataCatalogOutput> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copy(dataCatalogOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogOutputs(DataCatalogOutput ... dataCatalogOutputs) {
            this.dataCatalogOutputs(Arrays.asList(dataCatalogOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder> ... dataCatalogOutputs) {
            this.dataCatalogOutputs(Stream.of(dataCatalogOutputs).map(c -> (DataCatalogOutput)((DataCatalogOutput.Builder)DataCatalogOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DatabaseOutput.Builder> getDatabaseOutputs() {
            List<DatabaseOutput.Builder> result = DatabaseOutputListCopier.copyToBuilder(this.databaseOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabaseOutputs(Collection<DatabaseOutput.BuilderImpl> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copyFromBuilder(databaseOutputs);
        }

        @Override
        public final Builder databaseOutputs(Collection<DatabaseOutput> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copy(databaseOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseOutputs(DatabaseOutput ... databaseOutputs) {
            this.databaseOutputs(Arrays.asList(databaseOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseOutputs(Consumer<DatabaseOutput.Builder> ... databaseOutputs) {
            this.databaseOutputs(Stream.of(databaseOutputs).map(c -> (DatabaseOutput)((DatabaseOutput.Builder)DatabaseOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RecipeReference.Builder getRecipeReference() {
            return this.recipeReference != null ? this.recipeReference.toBuilder() : null;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final JobSample.Builder getJobSample() {
            return this.jobSample != null ? this.jobSample.toBuilder() : null;
        }

        public final void setJobSample(JobSample.BuilderImpl jobSample) {
            this.jobSample = jobSample != null ? jobSample.build() : null;
        }

        @Override
        public final Builder jobSample(JobSample jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        public final List<ValidationConfiguration.Builder> getValidationConfigurations() {
            List<ValidationConfiguration.Builder> result = ValidationConfigurationListCopier.copyToBuilder(this.validationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationConfigurations(Collection<ValidationConfiguration.BuilderImpl> validationConfigurations) {
            this.validationConfigurations = ValidationConfigurationListCopier.copyFromBuilder(validationConfigurations);
        }

        @Override
        public final Builder validationConfigurations(Collection<ValidationConfiguration> validationConfigurations) {
            this.validationConfigurations = ValidationConfigurationListCopier.copy(validationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationConfigurations(ValidationConfiguration ... validationConfigurations) {
            this.validationConfigurations(Arrays.asList(validationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationConfigurations(Consumer<ValidationConfiguration.Builder> ... validationConfigurations) {
            this.validationConfigurations(Stream.of(validationConfigurations).map(c -> (ValidationConfiguration)((ValidationConfiguration.Builder)ValidationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public JobRun build() {
            return new JobRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRun> {
        public Builder attempt(Integer var1);

        public Builder completedOn(Instant var1);

        public Builder datasetName(String var1);

        public Builder errorMessage(String var1);

        public Builder executionTime(Integer var1);

        public Builder jobName(String var1);

        public Builder runId(String var1);

        public Builder state(String var1);

        public Builder state(JobRunState var1);

        public Builder logSubscription(String var1);

        public Builder logSubscription(LogSubscription var1);

        public Builder logGroupName(String var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder dataCatalogOutputs(Collection<DataCatalogOutput> var1);

        public Builder dataCatalogOutputs(DataCatalogOutput ... var1);

        public Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder> ... var1);

        public Builder databaseOutputs(Collection<DatabaseOutput> var1);

        public Builder databaseOutputs(DatabaseOutput ... var1);

        public Builder databaseOutputs(Consumer<DatabaseOutput.Builder> ... var1);

        public Builder recipeReference(RecipeReference var1);

        default public Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return this.recipeReference((RecipeReference)((RecipeReference.Builder)RecipeReference.builder().applyMutation(recipeReference)).build());
        }

        public Builder startedBy(String var1);

        public Builder startedOn(Instant var1);

        public Builder jobSample(JobSample var1);

        default public Builder jobSample(Consumer<JobSample.Builder> jobSample) {
            return this.jobSample((JobSample)((JobSample.Builder)JobSample.builder().applyMutation(jobSample)).build());
        }

        public Builder validationConfigurations(Collection<ValidationConfiguration> var1);

        public Builder validationConfigurations(ValidationConfiguration ... var1);

        public Builder validationConfigurations(Consumer<ValidationConfiguration.Builder> ... var1);
    }
}

