/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.ValuesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterExpression> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(FilterExpression.getter(FilterExpression::expression)).setter(FilterExpression.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<Map<String, String>> VALUES_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ValuesMap").getter(FilterExpression.getter(FilterExpression::valuesMap)).setter(FilterExpression.setter(Builder::valuesMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, VALUES_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final Map<String, String> valuesMap;

    private FilterExpression(BuilderImpl builder) {
        this.expression = builder.expression;
        this.valuesMap = builder.valuesMap;
    }

    public final String expression() {
        return this.expression;
    }

    public final boolean hasValuesMap() {
        return this.valuesMap != null && !(this.valuesMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> valuesMap() {
        return this.valuesMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValuesMap() ? this.valuesMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterExpression)) {
            return false;
        }
        FilterExpression other = (FilterExpression)obj;
        return Objects.equals(this.expression(), other.expression()) && this.hasValuesMap() == other.hasValuesMap() && Objects.equals(this.valuesMap(), other.valuesMap());
    }

    public final String toString() {
        return ToString.builder((String)"FilterExpression").add("Expression", (Object)this.expression()).add("ValuesMap", this.hasValuesMap() ? this.valuesMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "ValuesMap": {
                return Optional.ofNullable(clazz.cast(this.valuesMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterExpression, T> g) {
        return obj -> g.apply((FilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private Map<String, String> valuesMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterExpression model) {
            this.expression(model.expression);
            this.valuesMap(model.valuesMap);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Map<String, String> getValuesMap() {
            if (this.valuesMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.valuesMap;
        }

        public final void setValuesMap(Map<String, String> valuesMap) {
            this.valuesMap = ValuesMapCopier.copy(valuesMap);
        }

        @Override
        public final Builder valuesMap(Map<String, String> valuesMap) {
            this.valuesMap = ValuesMapCopier.copy(valuesMap);
            return this;
        }

        public FilterExpression build() {
            return new FilterExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterExpression> {
        public Builder expression(String var1);

        public Builder valuesMap(Map<String, String> var1);
    }
}

