/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.eventstream.ClientConnectionContinuation;
import software.amazon.awssdk.crt.eventstream.ClientConnectionContinuationHandler;
import software.amazon.awssdk.crt.eventstream.ClientConnectionHandler;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageFlushCallback;
import software.amazon.awssdk.crt.eventstream.MessageType;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.ClientTlsContext;
import software.amazon.awssdk.crt.io.SocketOptions;

public class ClientConnection
extends CrtResource {
    CompletableFuture<Integer> closeFuture = new CompletableFuture();

    ClientConnection(long clientConnection) {
        this.acquireNativeHandle(clientConnection);
        ClientConnection.acquireClientConnection(clientConnection);
    }

    public void closeConnection(int shutdownErrorCode) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        ClientConnection.closeClientConnection(this.getNativeHandle(), shutdownErrorCode);
    }

    public boolean isOpen() {
        if (this.isNull()) {
            return false;
        }
        return ClientConnection.isClientConnectionOpen(this.getNativeHandle());
    }

    public CompletableFuture<Void> sendProtocolMessage(List<Header> headers, byte[] payload, MessageType messsageType, int messageFlags) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        CompletableFuture<Void> messageFlush = new CompletableFuture<Void>();
        this.sendProtocolMessage(headers, payload, messsageType, messageFlags, errorCode -> {
            if (errorCode == 0) {
                messageFlush.complete(null);
            } else {
                messageFlush.completeExceptionally(new CrtRuntimeException(errorCode, CRT.awsErrorString(errorCode)));
            }
        });
        return messageFlush;
    }

    public void sendProtocolMessage(List<Header> headers, byte[] payload, MessageType messsageType, int messageFlags, MessageFlushCallback callback) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        byte[] headersBuf = headers != null ? Header.marshallHeadersForJNI(headers) : null;
        int result = ClientConnection.sendProtocolMessage(this.getNativeHandle(), headersBuf, payload, messsageType.getEnumValue(), messageFlags, callback);
        if (result != 0) {
            int errorCode = CRT.awsLastError();
            throw new CrtRuntimeException(errorCode, CRT.awsErrorString(errorCode));
        }
    }

    public ClientConnectionContinuation newStream(ClientConnectionContinuationHandler continuationHandler) {
        ClientConnectionContinuation connectionContinuation;
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        long continuationHandle = ClientConnection.newClientStream(this.getNativeHandle(), continuationHandler);
        if (continuationHandle == 0L) {
            int lastError = CRT.awsLastError();
            throw new CrtRuntimeException(lastError, CRT.awsErrorString(lastError));
        }
        continuationHandler.continuation = connectionContinuation = new ClientConnectionContinuation(continuationHandle);
        return connectionContinuation;
    }

    public static CompletableFuture<Void> connect(String hostName, short port, SocketOptions socketOptions, ClientTlsContext tlsContext, ClientBootstrap bootstrap, final ClientConnectionHandler connectionHandler) {
        long tlsContextHandle = tlsContext != null ? tlsContext.getNativeHandle() : 0L;
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        ClientConnectionHandler handlerShim = new ClientConnectionHandler(){

            @Override
            protected void onConnectionSetup(ClientConnection connection, int errorCode) {
                connectionHandler.clientConnection = connection;
                connectionHandler.onConnectionSetup(connection, errorCode);
                if (errorCode == 0) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new CrtRuntimeException(errorCode, CRT.awsErrorName(errorCode)));
                }
            }

            @Override
            protected void onProtocolMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags) {
                connectionHandler.onProtocolMessage(headers, payload, messageType, messageFlags);
            }

            @Override
            protected void onConnectionClosed(int closeReason) {
                connectionHandler.clientConnection.closeFuture.complete(closeReason);
                connectionHandler.onConnectionClosed(closeReason);
            }
        };
        int resultCode = ClientConnection.clientConnect(hostName.getBytes(StandardCharsets.UTF_8), port, socketOptions.getNativeHandle(), tlsContextHandle, bootstrap.getNativeHandle(), handlerShim);
        if (resultCode != 0) {
            int lastError = CRT.awsLastError();
            throw new CrtRuntimeException(lastError, CRT.awsErrorName(lastError));
        }
        return future;
    }

    public CompletableFuture<Integer> getClosedFuture() {
        return this.closeFuture;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            ClientConnection.releaseClientConnection(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    private static native int clientConnect(byte[] var0, short var1, long var2, long var4, long var6, ClientConnectionHandler var8);

    private static native boolean isClientConnectionOpen(long var0);

    private static native void closeClientConnection(long var0, int var2);

    private static native void acquireClientConnection(long var0);

    private static native void releaseClientConnection(long var0);

    private static native int sendProtocolMessage(long var0, byte[] var2, byte[] var3, int var4, int var5, MessageFlushCallback var6);

    private static native long newClientStream(long var0, ClientConnectionContinuationHandler var2);
}

