/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.auth.credentials.Credentials;

public class CredentialsProvider
extends CrtResource {
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();

    public CompletableFuture<Credentials> getCredentials() {
        CompletableFuture<Credentials> future = new CompletableFuture<Credentials>();
        try {
            CredentialsProvider.credentialsProviderGetCredentials(this, future, this.getNativeHandle());
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private void onGetCredentialsComplete(CompletableFuture<Credentials> future, Credentials credentials) {
        if (credentials != null) {
            future.complete(credentials);
        } else {
            future.completeExceptionally(new RuntimeException("Failed to get a valid set of credentials"));
        }
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            CredentialsProvider.credentialsProviderDestroy(this, this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    private void onShutdownComplete() {
        Log.log(Log.LogLevel.Trace, Log.LogSubject.AuthCredentialsProvider, "CrtCredentialsProvider.onShutdownComplete");
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native void credentialsProviderDestroy(CredentialsProvider var0, long var1);

    private static native void credentialsProviderGetCredentials(CredentialsProvider var0, CompletableFuture<Credentials> var1, long var2);
}

