/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.s3.ResumeToken;

public class S3MetaRequest
extends CrtResource {
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();

    private void onShutdownComplete() {
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            S3MetaRequest.s3MetaRequestDestroy(this.getNativeHandle());
        }
    }

    void setMetaRequestNativeHandle(long nativeHandle) {
        this.acquireNativeHandle(nativeHandle);
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    public void cancel() {
        S3MetaRequest.s3MetaRequestCancel(this.getNativeHandle());
    }

    public ResumeToken pause() {
        return S3MetaRequest.s3MetaRequestPause(this.getNativeHandle());
    }

    public void incrementReadWindow(long bytes) {
        S3MetaRequest.s3MetaRequestIncrementReadWindow(this.getNativeHandle(), bytes);
    }

    private static native void s3MetaRequestDestroy(long var0);

    private static native void s3MetaRequestCancel(long var0);

    private static native ResumeToken s3MetaRequestPause(long var0);

    private static native void s3MetaRequestIncrementReadWindow(long var0, long var2);
}

