/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.s3.ChecksumAlgorithm;
import software.amazon.awssdk.crt.s3.ChecksumConfig;
import software.amazon.awssdk.crt.s3.ResumeToken;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandler;

public class S3MetaRequestOptions {
    private MetaRequestType metaRequestType;
    private ChecksumConfig checksumConfig;
    private HttpRequest httpRequest;
    private Path requestFilePath;
    private S3MetaRequestResponseHandler responseHandler;
    private CredentialsProvider credentialsProvider;
    private URI endpoint;
    private ResumeToken resumeToken;

    public S3MetaRequestOptions withMetaRequestType(MetaRequestType metaRequestType) {
        this.metaRequestType = metaRequestType;
        return this;
    }

    public MetaRequestType getMetaRequestType() {
        return this.metaRequestType;
    }

    public S3MetaRequestOptions withChecksumConfig(ChecksumConfig checksumConfig) {
        this.checksumConfig = checksumConfig;
        return this;
    }

    public ChecksumConfig getChecksumConfig() {
        return this.checksumConfig;
    }

    public S3MetaRequestOptions withChecksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
        ChecksumConfig config;
        this.checksumConfig = config = new ChecksumConfig().withChecksumAlgorithm(checksumAlgorithm).withChecksumLocation(ChecksumConfig.ChecksumLocation.TRAILER);
        return this;
    }

    public ChecksumAlgorithm getChecksumAlgorithm() {
        return this.checksumConfig.getChecksumAlgorithm();
    }

    public S3MetaRequestOptions withValidateChecksum(boolean validateChecksum) {
        ChecksumConfig config;
        this.checksumConfig = config = new ChecksumConfig().withValidateChecksum(validateChecksum);
        return this;
    }

    public boolean getValidateChecksum() {
        return this.checksumConfig.getValidateChecksum();
    }

    public S3MetaRequestOptions withHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public S3MetaRequestOptions withRequestFilePath(Path requestFilePath) {
        this.requestFilePath = requestFilePath;
        return this;
    }

    public Path getRequestFilePath() {
        return this.requestFilePath;
    }

    public S3MetaRequestOptions withResponseHandler(S3MetaRequestResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public S3MetaRequestResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public S3MetaRequestOptions withCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public S3MetaRequestOptions withEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public S3MetaRequestOptions withResumeToken(ResumeToken resumeToken) {
        this.resumeToken = resumeToken;
        return this;
    }

    public ResumeToken getResumeToken() {
        return this.resumeToken;
    }

    public static enum MetaRequestType {
        DEFAULT(0),
        GET_OBJECT(1),
        PUT_OBJECT(2),
        COPY_OBJECT(3);

        private int nativeValue;
        private static Map<Integer, MetaRequestType> enumMapping;

        private MetaRequestType(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        public static MetaRequestType getEnumValueFromInteger(int value) {
            MetaRequestType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Invalid S3 Meta Request type");
        }

        private static Map<Integer, MetaRequestType> buildEnumMapping() {
            HashMap<Integer, MetaRequestType> enumMapping = new HashMap<Integer, MetaRequestType>();
            enumMapping.put(DEFAULT.getNativeValue(), DEFAULT);
            enumMapping.put(GET_OBJECT.getNativeValue(), GET_OBJECT);
            enumMapping.put(PUT_OBJECT.getNativeValue(), PUT_OBJECT);
            enumMapping.put(COPY_OBJECT.getNativeValue(), COPY_OBJECT);
            return enumMapping;
        }

        static {
            enumMapping = MetaRequestType.buildEnumMapping();
        }
    }
}

