/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyEnvironmentVariableSetting;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.io.StandardRetryOptions;
import software.amazon.awssdk.crt.io.TlsConnectionOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.s3.ChecksumAlgorithm;
import software.amazon.awssdk.crt.s3.ChecksumConfig;
import software.amazon.awssdk.crt.s3.ResumeToken;
import software.amazon.awssdk.crt.s3.S3ClientOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequest;
import software.amazon.awssdk.crt.s3.S3MetaRequestOptions;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandlerNativeAdapter;
import software.amazon.awssdk.crt.s3.S3TcpKeepAliveOptions;

public class S3Client
extends CrtResource {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();
    private final String region;

    public S3Client(S3ClientOptions options) throws CrtRuntimeException {
        TlsContext tlsCtx = options.getTlsContext();
        this.region = options.getRegion();
        int proxyConnectionType = 0;
        String proxyHost = null;
        int proxyPort = 0;
        TlsContext proxyTlsContext = null;
        int proxyAuthorizationType = 0;
        String proxyAuthorizationUsername = null;
        String proxyAuthorizationPassword = null;
        HttpProxyOptions proxyOptions = options.getProxyOptions();
        if (proxyOptions != null) {
            proxyConnectionType = proxyOptions.getConnectionType().getValue();
            proxyHost = proxyOptions.getHost();
            proxyPort = proxyOptions.getPort();
            proxyTlsContext = proxyOptions.getTlsContext();
            proxyAuthorizationType = proxyOptions.getAuthorizationType().getValue();
            proxyAuthorizationUsername = proxyOptions.getAuthorizationUsername();
            proxyAuthorizationPassword = proxyOptions.getAuthorizationPassword();
        }
        int environmentVariableProxyConnectionType = 0;
        TlsConnectionOptions environmentVariableProxyTlsConnectionOptions = null;
        int environmentVariableType = 1;
        HttpProxyEnvironmentVariableSetting environmentVariableSetting = options.getHttpProxyEnvironmentVariableSetting();
        if (environmentVariableSetting != null) {
            environmentVariableProxyConnectionType = environmentVariableSetting.getConnectionType().getValue();
            environmentVariableProxyTlsConnectionOptions = environmentVariableSetting.getTlsConnectionOptions();
            environmentVariableType = environmentVariableSetting.getEnvironmentVariableType().getValue();
        }
        HttpMonitoringOptions monitoringOptions = options.getMonitoringOptions();
        long monitoringThroughputThresholdInBytesPerSecond = 0L;
        int monitoringFailureIntervalInSeconds = 0;
        if (monitoringOptions != null) {
            monitoringThroughputThresholdInBytesPerSecond = monitoringOptions.getMinThroughputBytesPerSecond();
            monitoringFailureIntervalInSeconds = monitoringOptions.getAllowableThroughputFailureIntervalSeconds();
        }
        this.acquireNativeHandle(S3Client.s3ClientNew(this, this.region.getBytes(UTF8), options.getClientBootstrap().getNativeHandle(), tlsCtx != null ? tlsCtx.getNativeHandle() : 0L, options.getCredentialsProvider().getNativeHandle(), options.getPartSize(), options.getThroughputTargetGbps(), options.getReadBackpressureEnabled(), options.getInitialReadWindowSize(), options.getMaxConnections(), options.getStandardRetryOptions(), options.getComputeContentMd5(), proxyConnectionType, proxyHost != null ? proxyHost.getBytes(UTF8) : null, proxyPort, proxyTlsContext != null ? proxyTlsContext.getNativeHandle() : 0L, proxyAuthorizationType, proxyAuthorizationUsername != null ? proxyAuthorizationUsername.getBytes(UTF8) : null, proxyAuthorizationPassword != null ? proxyAuthorizationPassword.getBytes(UTF8) : null, environmentVariableProxyConnectionType, environmentVariableProxyTlsConnectionOptions != null ? environmentVariableProxyTlsConnectionOptions.getNativeHandle() : 0L, environmentVariableType, options.getConnectTimeoutMs(), options.getTcpKeepAliveOptions(), monitoringThroughputThresholdInBytesPerSecond, monitoringFailureIntervalInSeconds));
        this.addReferenceTo(options.getClientBootstrap());
        this.addReferenceTo(options.getCredentialsProvider());
    }

    private void onShutdownComplete() {
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public S3MetaRequest makeMetaRequest(S3MetaRequestOptions options) {
        if (options.getHttpRequest() == null) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.S3Client, "S3Client.makeMetaRequest has invalid options; Http Request cannot be null.");
            return null;
        }
        if (options.getResponseHandler() == null) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.S3Client, "S3Client.makeMetaRequest has invalid options; Response Handler cannot be null.");
            return null;
        }
        S3MetaRequest metaRequest = new S3MetaRequest();
        S3MetaRequestResponseHandlerNativeAdapter responseHandlerNativeAdapter = new S3MetaRequestResponseHandlerNativeAdapter(options.getResponseHandler());
        byte[] httpRequestBytes = options.getHttpRequest().marshalForJni();
        byte[] requestFilePath = null;
        if (options.getRequestFilePath() != null) {
            requestFilePath = options.getRequestFilePath().toString().getBytes(UTF8);
        }
        long credentialsProviderNativeHandle = 0L;
        if (options.getCredentialsProvider() != null) {
            credentialsProviderNativeHandle = options.getCredentialsProvider().getNativeHandle();
        }
        URI endpoint = options.getEndpoint();
        ChecksumConfig checksumConfig = options.getChecksumConfig() != null ? options.getChecksumConfig() : new ChecksumConfig();
        long metaRequestNativeHandle = S3Client.s3ClientMakeMetaRequest(this.getNativeHandle(), metaRequest, this.region.getBytes(UTF8), options.getMetaRequestType().getNativeValue(), checksumConfig.getChecksumLocation().getNativeValue(), checksumConfig.getChecksumAlgorithm().getNativeValue(), checksumConfig.getValidateChecksum(), ChecksumAlgorithm.marshallAlgorithmsForJNI(checksumConfig.getValidateChecksumAlgorithmList()), httpRequestBytes, options.getHttpRequest().getBodyStream(), requestFilePath, credentialsProviderNativeHandle, responseHandlerNativeAdapter, endpoint == null ? null : endpoint.toString().getBytes(UTF8), options.getResumeToken());
        metaRequest.setMetaRequestNativeHandle(metaRequestNativeHandle);
        if (credentialsProviderNativeHandle != 0L) {
            metaRequest.addReferenceTo(options.getCredentialsProvider());
        }
        return metaRequest;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            S3Client.s3ClientDestroy(this.getNativeHandle());
        }
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native long s3ClientNew(S3Client var0, byte[] var1, long var2, long var4, long var6, long var8, double var10, boolean var12, long var13, int var15, StandardRetryOptions var16, boolean var17, int var18, byte[] var19, int var20, long var21, int var23, byte[] var24, byte[] var25, int var26, long var27, int var29, int var30, S3TcpKeepAliveOptions var31, long var32, int var34) throws CrtRuntimeException;

    private static native void s3ClientDestroy(long var0);

    private static native long s3ClientMakeMetaRequest(long var0, S3MetaRequest var2, byte[] var3, int var4, int var5, int var6, boolean var7, int[] var8, byte[] var9, HttpRequestBodyStream var10, byte[] var11, long var12, S3MetaRequestResponseHandlerNativeAdapter var14, byte[] var15, ResumeToken var16);
}

