/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.ErrorDocument;
import com.amazonaws.s3.model.IndexDocument;
import com.amazonaws.s3.model.RedirectAllRequestsTo;
import com.amazonaws.s3.model.RoutingRule;
import java.util.List;
import java.util.Objects;

public class WebsiteConfiguration {
    ErrorDocument errorDocument;
    IndexDocument indexDocument;
    RedirectAllRequestsTo redirectAllRequestsTo;
    List<RoutingRule> routingRules;

    WebsiteConfiguration() {
        this.errorDocument = null;
        this.indexDocument = null;
        this.redirectAllRequestsTo = null;
        this.routingRules = null;
    }

    protected WebsiteConfiguration(BuilderImpl builder) {
        this.errorDocument = builder.errorDocument;
        this.indexDocument = builder.indexDocument;
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.routingRules = builder.routingRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(WebsiteConfiguration.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof WebsiteConfiguration;
    }

    public ErrorDocument errorDocument() {
        return this.errorDocument;
    }

    public IndexDocument indexDocument() {
        return this.indexDocument;
    }

    public RedirectAllRequestsTo redirectAllRequestsTo() {
        return this.redirectAllRequestsTo;
    }

    public List<RoutingRule> routingRules() {
        return this.routingRules;
    }

    protected static class BuilderImpl
    implements Builder {
        ErrorDocument errorDocument;
        IndexDocument indexDocument;
        RedirectAllRequestsTo redirectAllRequestsTo;
        List<RoutingRule> routingRules;

        protected BuilderImpl() {
        }

        private BuilderImpl(WebsiteConfiguration model) {
            this.errorDocument(model.errorDocument);
            this.indexDocument(model.indexDocument);
            this.redirectAllRequestsTo(model.redirectAllRequestsTo);
            this.routingRules(model.routingRules);
        }

        @Override
        public WebsiteConfiguration build() {
            return new WebsiteConfiguration(this);
        }

        @Override
        public final Builder errorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        @Override
        public final Builder indexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
            return this;
        }

        @Override
        public final Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        @Override
        public final Builder routingRules(List<RoutingRule> routingRules) {
            this.routingRules = routingRules;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public ErrorDocument errorDocument() {
            return this.errorDocument;
        }

        public IndexDocument indexDocument() {
            return this.indexDocument;
        }

        public RedirectAllRequestsTo redirectAllRequestsTo() {
            return this.redirectAllRequestsTo;
        }

        public List<RoutingRule> routingRules() {
            return this.routingRules;
        }
    }

    public static interface Builder {
        public Builder errorDocument(ErrorDocument var1);

        public Builder indexDocument(IndexDocument var1);

        public Builder redirectAllRequestsTo(RedirectAllRequestsTo var1);

        public Builder routingRules(List<RoutingRule> var1);

        public WebsiteConfiguration build();
    }
}

