/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import java.time.Instant;
import java.util.Objects;

public class Part {
    Integer partNumber;
    Instant lastModified;
    String eTag;
    Integer size;

    Part() {
        this.partNumber = null;
        this.lastModified = null;
        this.eTag = "";
        this.size = null;
    }

    protected Part(BuilderImpl builder) {
        this.partNumber = builder.partNumber;
        this.lastModified = builder.lastModified;
        this.eTag = builder.eTag;
        this.size = builder.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(Part.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof Part;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String eTag() {
        return this.eTag;
    }

    public Integer size() {
        return this.size;
    }

    protected static class BuilderImpl
    implements Builder {
        Integer partNumber;
        Instant lastModified;
        String eTag;
        Integer size;

        protected BuilderImpl() {
        }

        private BuilderImpl(Part model) {
            this.partNumber(model.partNumber);
            this.lastModified(model.lastModified);
            this.eTag(model.eTag);
            this.size(model.size);
        }

        @Override
        public Part build() {
            return new Part(this);
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public Integer partNumber() {
            return this.partNumber;
        }

        public Instant lastModified() {
            return this.lastModified;
        }

        public String eTag() {
            return this.eTag;
        }

        public Integer size() {
            return this.size;
        }
    }

    public static interface Builder {
        public Builder partNumber(Integer var1);

        public Builder lastModified(Instant var1);

        public Builder eTag(String var1);

        public Builder size(Integer var1);

        public Part build();
    }
}

