/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.CORSConfiguration;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class PutBucketCorsRequest {
    String bucket;
    CORSConfiguration cORSConfiguration;
    String contentMD5;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    PutBucketCorsRequest() {
        this.bucket = "";
        this.cORSConfiguration = null;
        this.contentMD5 = "";
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected PutBucketCorsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.cORSConfiguration = builder.cORSConfiguration;
        this.contentMD5 = builder.contentMD5;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutBucketCorsRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutBucketCorsRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public CORSConfiguration cORSConfiguration() {
        return this.cORSConfiguration;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        CORSConfiguration cORSConfiguration;
        String contentMD5;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutBucketCorsRequest model) {
            this.bucket(model.bucket);
            this.cORSConfiguration(model.cORSConfiguration);
            this.contentMD5(model.contentMD5);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public PutBucketCorsRequest build() {
            return new PutBucketCorsRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder cORSConfiguration(CORSConfiguration cORSConfiguration) {
            this.cORSConfiguration = cORSConfiguration;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public CORSConfiguration cORSConfiguration() {
            return this.cORSConfiguration;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder cORSConfiguration(CORSConfiguration var1);

        public Builder contentMD5(String var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public PutBucketCorsRequest build();
    }
}

