/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.InventoryEncryption;
import com.amazonaws.s3.model.InventoryFormat;
import java.util.Objects;

public class InventoryS3BucketDestination {
    String accountId;
    String bucket;
    InventoryFormat format;
    String prefix;
    InventoryEncryption encryption;

    InventoryS3BucketDestination() {
        this.accountId = "";
        this.bucket = "";
        this.format = null;
        this.prefix = "";
        this.encryption = null;
    }

    protected InventoryS3BucketDestination(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.bucket = builder.bucket;
        this.format = builder.format;
        this.prefix = builder.prefix;
        this.encryption = builder.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(InventoryS3BucketDestination.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof InventoryS3BucketDestination;
    }

    public String accountId() {
        return this.accountId;
    }

    public String bucket() {
        return this.bucket;
    }

    public InventoryFormat format() {
        return this.format;
    }

    public String prefix() {
        return this.prefix;
    }

    public InventoryEncryption encryption() {
        return this.encryption;
    }

    protected static class BuilderImpl
    implements Builder {
        String accountId;
        String bucket;
        InventoryFormat format;
        String prefix;
        InventoryEncryption encryption;

        protected BuilderImpl() {
        }

        private BuilderImpl(InventoryS3BucketDestination model) {
            this.accountId(model.accountId);
            this.bucket(model.bucket);
            this.format(model.format);
            this.prefix(model.prefix);
            this.encryption(model.encryption);
        }

        @Override
        public InventoryS3BucketDestination build() {
            return new InventoryS3BucketDestination(this);
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder format(InventoryFormat format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public final Builder encryption(InventoryEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String accountId() {
            return this.accountId;
        }

        public String bucket() {
            return this.bucket;
        }

        public InventoryFormat format() {
            return this.format;
        }

        public String prefix() {
            return this.prefix;
        }

        public InventoryEncryption encryption() {
            return this.encryption;
        }
    }

    public static interface Builder {
        public Builder accountId(String var1);

        public Builder bucket(String var1);

        public Builder format(InventoryFormat var1);

        public Builder prefix(String var1);

        public Builder encryption(InventoryEncryption var1);

        public InventoryS3BucketDestination build();
    }
}

