/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import java.time.Instant;
import java.util.Objects;

public class Bucket {
    String name;
    Instant creationDate;

    Bucket() {
        this.name = "";
        this.creationDate = null;
    }

    protected Bucket(BuilderImpl builder) {
        this.name = builder.name;
        this.creationDate = builder.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(Bucket.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof Bucket;
    }

    public String name() {
        return this.name;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    protected static class BuilderImpl
    implements Builder {
        String name;
        Instant creationDate;

        protected BuilderImpl() {
        }

        private BuilderImpl(Bucket model) {
            this.name(model.name);
            this.creationDate(model.creationDate);
        }

        @Override
        public Bucket build() {
            return new Bucket(this);
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String name() {
            return this.name;
        }

        public Instant creationDate() {
            return this.creationDate;
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder creationDate(Instant var1);

        public Bucket build();
    }
}

