/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.s3;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.crt.CrtRuntimeException;

public class CrtS3RuntimeException
extends CrtRuntimeException {
    private final int statusCode;
    private final String awsErrorCode;
    private final String awsErrorMessage;
    private final String errorPayload;
    private static final String codeBeginBlock = new String("<Code>");
    private static final String codeEndBlock = new String("</Code>");
    private static final String messageBeginBlock = new String("<Message>");
    private static final String messageEndBlock = new String("</Message>");

    public CrtS3RuntimeException(int errorCode, int responseStatus, String errorPayload) {
        super(errorCode);
        this.statusCode = responseStatus;
        this.errorPayload = errorPayload;
        this.awsErrorCode = this.GetElementFromPyload(errorPayload, codeBeginBlock, codeEndBlock);
        this.awsErrorMessage = this.GetElementFromPyload(errorPayload, messageBeginBlock, messageEndBlock);
    }

    public CrtS3RuntimeException(int errorCode, int responseStatus, byte[] errorPayload) {
        super(errorCode);
        String errorString = new String(errorPayload, StandardCharsets.UTF_8);
        this.statusCode = responseStatus;
        this.errorPayload = errorString;
        this.awsErrorCode = this.GetElementFromPyload(this.errorPayload, codeBeginBlock, codeEndBlock);
        this.awsErrorMessage = this.GetElementFromPyload(this.errorPayload, messageBeginBlock, messageEndBlock);
    }

    private String GetElementFromPyload(String errorPayload, String beginBlock, String endBlock) {
        Pattern regexFormat = Pattern.compile(beginBlock + ".*" + endBlock);
        Matcher matcher = regexFormat.matcher(errorPayload);
        String result = "";
        if (matcher.find()) {
            result = errorPayload.substring(matcher.start() + beginBlock.length(), matcher.end() - endBlock.length());
        }
        return result;
    }

    public String getAwsErrorCode() {
        return this.awsErrorCode;
    }

    public String getAwsErrorMessage() {
        return this.awsErrorMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        return String.format("%s: response status code(%d). aws error code(%s), aws error message(%s)", super.toString(), this.statusCode, this.awsErrorCode, this.awsErrorMessage);
    }
}

