/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.TransitionStorageClass;
import java.time.Instant;
import java.util.Objects;

public class Transition {
    Instant date;
    Integer days;
    TransitionStorageClass storageClass;

    Transition() {
        this.date = null;
        this.days = null;
        this.storageClass = null;
    }

    protected Transition(BuilderImpl builder) {
        this.date = builder.date;
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(Transition.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof Transition;
    }

    public Instant date() {
        return this.date;
    }

    public Integer days() {
        return this.days;
    }

    public TransitionStorageClass storageClass() {
        return this.storageClass;
    }

    protected static class BuilderImpl
    implements Builder {
        Instant date;
        Integer days;
        TransitionStorageClass storageClass;

        protected BuilderImpl() {
        }

        private BuilderImpl(Transition model) {
            this.date(model.date);
            this.days(model.days);
            this.storageClass(model.storageClass);
        }

        @Override
        public Transition build() {
            return new Transition(this);
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        @Override
        public final Builder storageClass(TransitionStorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public Instant date() {
            return this.date;
        }

        public Integer days() {
            return this.days;
        }

        public TransitionStorageClass storageClass() {
            return this.storageClass;
        }
    }

    public static interface Builder {
        public Builder date(Instant var1);

        public Builder days(Integer var1);

        public Builder storageClass(TransitionStorageClass var1);

        public Transition build();
    }
}

