/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.Encryption;
import com.amazonaws.s3.model.Grant;
import com.amazonaws.s3.model.MetadataEntry;
import com.amazonaws.s3.model.ObjectCannedACL;
import com.amazonaws.s3.model.StorageClass;
import com.amazonaws.s3.model.Tagging;
import java.util.List;
import java.util.Objects;

public class S3Location {
    String bucketName;
    String prefix;
    Encryption encryption;
    ObjectCannedACL cannedACL;
    List<Grant> accessControlList;
    Tagging tagging;
    List<MetadataEntry> userMetadata;
    StorageClass storageClass;

    S3Location() {
        this.bucketName = "";
        this.prefix = "";
        this.encryption = null;
        this.cannedACL = null;
        this.accessControlList = null;
        this.tagging = null;
        this.userMetadata = null;
        this.storageClass = null;
    }

    protected S3Location(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.encryption = builder.encryption;
        this.cannedACL = builder.cannedACL;
        this.accessControlList = builder.accessControlList;
        this.tagging = builder.tagging;
        this.userMetadata = builder.userMetadata;
        this.storageClass = builder.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(S3Location.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof S3Location;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String prefix() {
        return this.prefix;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public ObjectCannedACL cannedACL() {
        return this.cannedACL;
    }

    public List<Grant> accessControlList() {
        return this.accessControlList;
    }

    public Tagging tagging() {
        return this.tagging;
    }

    public List<MetadataEntry> userMetadata() {
        return this.userMetadata;
    }

    public StorageClass storageClass() {
        return this.storageClass;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucketName;
        String prefix;
        Encryption encryption;
        ObjectCannedACL cannedACL;
        List<Grant> accessControlList;
        Tagging tagging;
        List<MetadataEntry> userMetadata;
        StorageClass storageClass;

        protected BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.encryption(model.encryption);
            this.cannedACL(model.cannedACL);
            this.accessControlList(model.accessControlList);
            this.tagging(model.tagging);
            this.userMetadata(model.userMetadata);
            this.storageClass(model.storageClass);
        }

        @Override
        public S3Location build() {
            return new S3Location(this);
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        @Override
        public final Builder cannedACL(ObjectCannedACL cannedACL) {
            this.cannedACL = cannedACL;
            return this;
        }

        @Override
        public final Builder accessControlList(List<Grant> accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        @Override
        public final Builder tagging(Tagging tagging) {
            this.tagging = tagging;
            return this;
        }

        @Override
        public final Builder userMetadata(List<MetadataEntry> userMetadata) {
            this.userMetadata = userMetadata;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucketName() {
            return this.bucketName;
        }

        public String prefix() {
            return this.prefix;
        }

        public Encryption encryption() {
            return this.encryption;
        }

        public ObjectCannedACL cannedACL() {
            return this.cannedACL;
        }

        public List<Grant> accessControlList() {
            return this.accessControlList;
        }

        public Tagging tagging() {
            return this.tagging;
        }

        public List<MetadataEntry> userMetadata() {
            return this.userMetadata;
        }

        public StorageClass storageClass() {
            return this.storageClass;
        }
    }

    public static interface Builder {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder encryption(Encryption var1);

        public Builder cannedACL(ObjectCannedACL var1);

        public Builder accessControlList(List<Grant> var1);

        public Builder tagging(Tagging var1);

        public Builder userMetadata(List<MetadataEntry> var1);

        public Builder storageClass(StorageClass var1);

        public S3Location build();
    }
}

