/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.io.EventLoopGroup;
import software.amazon.awssdk.crt.io.HostResolver;

public final class ClientBootstrap
extends CrtResource {
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();

    public ClientBootstrap(EventLoopGroup elg, HostResolver hr) throws CrtRuntimeException {
        if (elg == null) {
            elg = EventLoopGroup.getOrCreateStaticDefault();
        }
        if (hr == null) {
            hr = HostResolver.getOrCreateStaticDefault();
        }
        this.acquireNativeHandle(ClientBootstrap.clientBootstrapNew(this, elg.getNativeHandle(), hr.getNativeHandle()));
        this.addReferenceTo(hr);
        this.addReferenceTo(elg);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            ClientBootstrap.clientBootstrapDestroy(this.getNativeHandle());
        }
    }

    private void onShutdownComplete() {
        Log.log(Log.LogLevel.Trace, Log.LogSubject.IoChannelBootstrap, "ClientBootstrap.onShutdownComplete");
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native long clientBootstrapNew(ClientBootstrap var0, long var1, long var3) throws CrtRuntimeException;

    private static native void clientBootstrapDestroy(long var0);
}

