/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.eventstream.ServerListenerHandler;
import software.amazon.awssdk.crt.io.ServerBootstrap;
import software.amazon.awssdk.crt.io.ServerTlsContext;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;

public class ServerListener
extends CrtResource {
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();
    private TlsContext tlsContext = null;
    private final ServerBootstrap serverBootstrap;

    public ServerListener(String hostName, short port, SocketOptions socketOptions, ServerTlsContext tlsContext, ServerBootstrap serverBootstrap, ServerListenerHandler handler) {
        long tlsContextPtr = tlsContext != null ? tlsContext.getNativeHandle() : 0L;
        this.acquireNativeHandle(ServerListener.serverListenerNew(this, hostName.getBytes(StandardCharsets.UTF_8), port, socketOptions.getNativeHandle(), tlsContextPtr, serverBootstrap.getNativeHandle(), handler));
        if (tlsContext != null) {
            this.addReferenceTo(tlsContext);
            this.tlsContext = tlsContext;
        }
        this.addReferenceTo(serverBootstrap);
        this.serverBootstrap = serverBootstrap;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            ServerListener.release(this.getNativeHandle());
            this.removeReferenceTo(this.serverBootstrap);
            if (this.tlsContext != null) {
                this.removeReferenceTo(this.tlsContext);
            }
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    private void onShutdownComplete() {
        Log.log(Log.LogLevel.Trace, Log.LogSubject.EventStreamServerListener, "ServerListener.onShutdownComplete");
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native long serverListenerNew(ServerListener var0, byte[] var1, short var2, long var3, long var5, long var7, ServerListenerHandler var9);

    private static native void release(long var0);
}

