/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.DomainResourceFilter;
import software.amazon.awssdk.services.controlcatalog.model.DomainResourceFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectiveFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectiveFilter> {
    private static final SdkField<List<DomainResourceFilter>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(ObjectiveFilter.getter(ObjectiveFilter::domains)).setter(ObjectiveFilter.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainResourceFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ObjectiveFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DomainResourceFilter> domains;

    private ObjectiveFilter(BuilderImpl builder) {
        this.domains = builder.domains;
    }

    public final boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public final List<DomainResourceFilter> domains() {
        return this.domains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomains() ? this.domains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectiveFilter)) {
            return false;
        }
        ObjectiveFilter other = (ObjectiveFilter)obj;
        return this.hasDomains() == other.hasDomains() && Objects.equals(this.domains(), other.domains());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectiveFilter").add("Domains", this.hasDomains() ? this.domains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DomainResourceFilter>>> map = new HashMap<String, SdkField<List<DomainResourceFilter>>>();
        map.put("Domains", DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectiveFilter, T> g) {
        return obj -> g.apply((ObjectiveFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DomainResourceFilter> domains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectiveFilter model) {
            this.domains(model.domains);
        }

        public final List<DomainResourceFilter.Builder> getDomains() {
            List<DomainResourceFilter.Builder> result = DomainResourceFilterListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<DomainResourceFilter.BuilderImpl> domains) {
            this.domains = DomainResourceFilterListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<DomainResourceFilter> domains) {
            this.domains = DomainResourceFilterListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainResourceFilter ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<DomainResourceFilter.Builder> ... domains) {
            this.domains(Stream.of(domains).map(c -> (DomainResourceFilter)((DomainResourceFilter.Builder)DomainResourceFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ObjectiveFilter build() {
            return new ObjectiveFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectiveFilter> {
        public Builder domains(Collection<DomainResourceFilter> var1);

        public Builder domains(DomainResourceFilter ... var1);

        public Builder domains(Consumer<DomainResourceFilter.Builder> ... var1);
    }
}

