/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.ControlCatalogResponse;
import software.amazon.awssdk.services.controlcatalog.model.ObjectiveSummary;
import software.amazon.awssdk.services.controlcatalog.model.ObjectiveSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectivesResponse
extends ControlCatalogResponse
implements ToCopyableBuilder<Builder, ListObjectivesResponse> {
    private static final SdkField<List<ObjectiveSummary>> OBJECTIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Objectives").getter(ListObjectivesResponse.getter(ListObjectivesResponse::objectives)).setter(ListObjectivesResponse.setter(Builder::objectives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objectives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectiveSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObjectivesResponse.getter(ListObjectivesResponse::nextToken)).setter(ListObjectivesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTIVES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Objectives", OBJECTIVES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ObjectiveSummary> objectives;
    private final String nextToken;

    private ListObjectivesResponse(BuilderImpl builder) {
        super(builder);
        this.objectives = builder.objectives;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasObjectives() {
        return this.objectives != null && !(this.objectives instanceof SdkAutoConstructList);
    }

    public final List<ObjectiveSummary> objectives() {
        return this.objectives;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectives() ? this.objectives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectivesResponse)) {
            return false;
        }
        ListObjectivesResponse other = (ListObjectivesResponse)((Object)obj);
        return this.hasObjectives() == other.hasObjectives() && Objects.equals(this.objectives(), other.objectives()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListObjectivesResponse").add("Objectives", this.hasObjectives() ? this.objectives() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Objectives": {
                return Optional.ofNullable(clazz.cast(this.objectives()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectivesResponse, T> g) {
        return obj -> g.apply((ListObjectivesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlCatalogResponse.BuilderImpl
    implements Builder {
        private List<ObjectiveSummary> objectives = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectivesResponse model) {
            super(model);
            this.objectives(model.objectives);
            this.nextToken(model.nextToken);
        }

        public final List<ObjectiveSummary.Builder> getObjectives() {
            List<ObjectiveSummary.Builder> result = ObjectiveSummaryListCopier.copyToBuilder(this.objectives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectives(Collection<ObjectiveSummary.BuilderImpl> objectives) {
            this.objectives = ObjectiveSummaryListCopier.copyFromBuilder(objectives);
        }

        @Override
        public final Builder objectives(Collection<ObjectiveSummary> objectives) {
            this.objectives = ObjectiveSummaryListCopier.copy(objectives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectives(ObjectiveSummary ... objectives) {
            this.objectives(Arrays.asList(objectives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectives(Consumer<ObjectiveSummary.Builder> ... objectives) {
            this.objectives(Stream.of(objectives).map(c -> (ObjectiveSummary)((ObjectiveSummary.Builder)ObjectiveSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListObjectivesResponse build() {
            return new ListObjectivesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ControlCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectivesResponse> {
        public Builder objectives(Collection<ObjectiveSummary> var1);

        public Builder objectives(ObjectiveSummary ... var1);

        public Builder objectives(Consumer<ObjectiveSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

