/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.internal.UserAgentUtils;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;

public class ListDocumentClassifiersIterable
implements SdkIterable<ListDocumentClassifiersResponse> {
    private final ComprehendClient client;
    private final ListDocumentClassifiersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDocumentClassifiersIterable(ComprehendClient client, ListDocumentClassifiersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDocumentClassifiersResponseFetcher();
    }

    public Iterator<ListDocumentClassifiersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDocumentClassifiersResponseFetcher
    implements SyncPageFetcher<ListDocumentClassifiersResponse> {
        private ListDocumentClassifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentClassifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDocumentClassifiersResponse nextPage(ListDocumentClassifiersResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentClassifiersIterable.this.client.listDocumentClassifiers(ListDocumentClassifiersIterable.this.firstRequest);
            }
            return ListDocumentClassifiersIterable.this.client.listDocumentClassifiers((ListDocumentClassifiersRequest)((Object)ListDocumentClassifiersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

