/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartOfSpeechTag
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartOfSpeechTag> {
    private static final SdkField<String> TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tag").getter(PartOfSpeechTag.getter(PartOfSpeechTag::tagAsString)).setter(PartOfSpeechTag.setter(Builder::tag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(PartOfSpeechTag.getter(PartOfSpeechTag::score)).setter(PartOfSpeechTag.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FIELD, SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Tag", TAG_FIELD);
            this.put("Score", SCORE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String tag;
    private final Float score;

    private PartOfSpeechTag(BuilderImpl builder) {
        this.tag = builder.tag;
        this.score = builder.score;
    }

    public final PartOfSpeechTagType tag() {
        return PartOfSpeechTagType.fromValue(this.tag);
    }

    public final String tagAsString() {
        return this.tag;
    }

    public final Float score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartOfSpeechTag)) {
            return false;
        }
        PartOfSpeechTag other = (PartOfSpeechTag)obj;
        return Objects.equals(this.tagAsString(), other.tagAsString()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"PartOfSpeechTag").add("Tag", (Object)this.tagAsString()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tag": {
                return Optional.ofNullable(clazz.cast(this.tagAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PartOfSpeechTag, T> g) {
        return obj -> g.apply((PartOfSpeechTag)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tag;
        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(PartOfSpeechTag model) {
            this.tag(model.tag);
            this.score(model.score);
        }

        public final String getTag() {
            return this.tag;
        }

        public final void setTag(String tag) {
            this.tag = tag;
        }

        @Override
        public final Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public final Builder tag(PartOfSpeechTagType tag) {
            this.tag(tag == null ? null : tag.toString());
            return this;
        }

        public final Float getScore() {
            return this.score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public PartOfSpeechTag build() {
            return new PartOfSpeechTag(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartOfSpeechTag> {
        public Builder tag(String var1);

        public Builder tag(PartOfSpeechTagType var1);

        public Builder score(Float var1);
    }
}

