/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentClassifierFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentClassifierFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DocumentClassifierFilter.getter(DocumentClassifierFilter::statusAsString)).setter(DocumentClassifierFilter.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DOCUMENT_CLASSIFIER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentClassifierName").getter(DocumentClassifierFilter.getter(DocumentClassifierFilter::documentClassifierName)).setter(DocumentClassifierFilter.setter(Builder::documentClassifierName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierName").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTimeBefore").getter(DocumentClassifierFilter.getter(DocumentClassifierFilter::submitTimeBefore)).setter(DocumentClassifierFilter.setter(Builder::submitTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeBefore").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTimeAfter").getter(DocumentClassifierFilter.getter(DocumentClassifierFilter::submitTimeAfter)).setter(DocumentClassifierFilter.setter(Builder::submitTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, DOCUMENT_CLASSIFIER_NAME_FIELD, SUBMIT_TIME_BEFORE_FIELD, SUBMIT_TIME_AFTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("DocumentClassifierName", DOCUMENT_CLASSIFIER_NAME_FIELD);
            this.put("SubmitTimeBefore", SUBMIT_TIME_BEFORE_FIELD);
            this.put("SubmitTimeAfter", SUBMIT_TIME_AFTER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String documentClassifierName;
    private final Instant submitTimeBefore;
    private final Instant submitTimeAfter;

    private DocumentClassifierFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.documentClassifierName = builder.documentClassifierName;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    public final ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String documentClassifierName() {
        return this.documentClassifierName;
    }

    public final Instant submitTimeBefore() {
        return this.submitTimeBefore;
    }

    public final Instant submitTimeAfter() {
        return this.submitTimeAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentClassifierName());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassifierFilter)) {
            return false;
        }
        DocumentClassifierFilter other = (DocumentClassifierFilter)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.documentClassifierName(), other.documentClassifierName()) && Objects.equals(this.submitTimeBefore(), other.submitTimeBefore()) && Objects.equals(this.submitTimeAfter(), other.submitTimeAfter());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentClassifierFilter").add("Status", (Object)this.statusAsString()).add("DocumentClassifierName", (Object)this.documentClassifierName()).add("SubmitTimeBefore", (Object)this.submitTimeBefore()).add("SubmitTimeAfter", (Object)this.submitTimeAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DocumentClassifierName": {
                return Optional.ofNullable(clazz.cast(this.documentClassifierName()));
            }
            case "SubmitTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.submitTimeBefore()));
            }
            case "SubmitTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.submitTimeAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassifierFilter, T> g) {
        return obj -> g.apply((DocumentClassifierFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String documentClassifierName;
        private Instant submitTimeBefore;
        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassifierFilter model) {
            this.status(model.status);
            this.documentClassifierName(model.documentClassifierName);
            this.submitTimeBefore(model.submitTimeBefore);
            this.submitTimeAfter(model.submitTimeAfter);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDocumentClassifierName() {
            return this.documentClassifierName;
        }

        public final void setDocumentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
        }

        @Override
        public final Builder documentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
            return this;
        }

        public final Instant getSubmitTimeBefore() {
            return this.submitTimeBefore;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final Instant getSubmitTimeAfter() {
            return this.submitTimeAfter;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public DocumentClassifierFilter build() {
            return new DocumentClassifierFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentClassifierFilter> {
        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder documentClassifierName(String var1);

        public Builder submitTimeBefore(Instant var1);

        public Builder submitTimeAfter(Instant var1);
    }
}

