/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem;
import software.amazon.awssdk.services.comprehend.model.ListOfExtractedCharactersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentMetadata> {
    private static final SdkField<Integer> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Pages").getter(DocumentMetadata.getter(DocumentMetadata::pages)).setter(DocumentMetadata.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build()}).build();
    private static final SdkField<List<ExtractedCharactersListItem>> EXTRACTED_CHARACTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExtractedCharacters").getter(DocumentMetadata.getter(DocumentMetadata::extractedCharacters)).setter(DocumentMetadata.setter(Builder::extractedCharacters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtractedCharacters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExtractedCharactersListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGES_FIELD, EXTRACTED_CHARACTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer pages;
    private final List<ExtractedCharactersListItem> extractedCharacters;

    private DocumentMetadata(BuilderImpl builder) {
        this.pages = builder.pages;
        this.extractedCharacters = builder.extractedCharacters;
    }

    public final Integer pages() {
        return this.pages;
    }

    public final boolean hasExtractedCharacters() {
        return this.extractedCharacters != null && !(this.extractedCharacters instanceof SdkAutoConstructList);
    }

    public final List<ExtractedCharactersListItem> extractedCharacters() {
        return this.extractedCharacters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pages());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtractedCharacters() ? this.extractedCharacters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        return Objects.equals(this.pages(), other.pages()) && this.hasExtractedCharacters() == other.hasExtractedCharacters() && Objects.equals(this.extractedCharacters(), other.extractedCharacters());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentMetadata").add("Pages", (Object)this.pages()).add("ExtractedCharacters", this.hasExtractedCharacters() ? this.extractedCharacters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
            case "ExtractedCharacters": {
                return Optional.ofNullable(clazz.cast(this.extractedCharacters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer pages;
        private List<ExtractedCharactersListItem> extractedCharacters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            this.pages(model.pages);
            this.extractedCharacters(model.extractedCharacters);
        }

        public final Integer getPages() {
            return this.pages;
        }

        public final void setPages(Integer pages) {
            this.pages = pages;
        }

        @Override
        public final Builder pages(Integer pages) {
            this.pages = pages;
            return this;
        }

        public final List<ExtractedCharactersListItem.Builder> getExtractedCharacters() {
            List<ExtractedCharactersListItem.Builder> result = ListOfExtractedCharactersCopier.copyToBuilder(this.extractedCharacters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtractedCharacters(Collection<ExtractedCharactersListItem.BuilderImpl> extractedCharacters) {
            this.extractedCharacters = ListOfExtractedCharactersCopier.copyFromBuilder(extractedCharacters);
        }

        @Override
        public final Builder extractedCharacters(Collection<ExtractedCharactersListItem> extractedCharacters) {
            this.extractedCharacters = ListOfExtractedCharactersCopier.copy(extractedCharacters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extractedCharacters(ExtractedCharactersListItem ... extractedCharacters) {
            this.extractedCharacters(Arrays.asList(extractedCharacters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extractedCharacters(Consumer<ExtractedCharactersListItem.Builder> ... extractedCharacters) {
            this.extractedCharacters(Stream.of(extractedCharacters).map(c -> (ExtractedCharactersListItem)((ExtractedCharactersListItem.Builder)ExtractedCharactersListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentMetadata> {
        public Builder pages(Integer var1);

        public Builder extractedCharacters(Collection<ExtractedCharactersListItem> var1);

        public Builder extractedCharacters(ExtractedCharactersListItem ... var1);

        public Builder extractedCharacters(Consumer<ExtractedCharactersListItem.Builder> ... var1);
    }
}

