/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentClassifierMode {
    MULTI_CLASS("MULTI_CLASS"),
    MULTI_LABEL("MULTI_LABEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentClassifierMode> VALUE_MAP;
    private final String value;

    private DocumentClassifierMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentClassifierMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentClassifierMode> knownValues() {
        EnumSet<DocumentClassifierMode> knownValues = EnumSet.allOf(DocumentClassifierMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentClassifierMode.class, DocumentClassifierMode::toString);
    }
}

