/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnlinkDeveloperIdentityRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(UnlinkDeveloperIdentityRequest.getter(UnlinkDeveloperIdentityRequest::identityId)).setter(UnlinkDeveloperIdentityRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(UnlinkDeveloperIdentityRequest.getter(UnlinkDeveloperIdentityRequest::identityPoolId)).setter(UnlinkDeveloperIdentityRequest.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<String> DEVELOPER_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeveloperProviderName").getter(UnlinkDeveloperIdentityRequest.getter(UnlinkDeveloperIdentityRequest::developerProviderName)).setter(UnlinkDeveloperIdentityRequest.setter(Builder::developerProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperProviderName").build()}).build();
    private static final SdkField<String> DEVELOPER_USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeveloperUserIdentifier").getter(UnlinkDeveloperIdentityRequest.getter(UnlinkDeveloperIdentityRequest::developerUserIdentifier)).setter(UnlinkDeveloperIdentityRequest.setter(Builder::developerUserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperUserIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD, IDENTITY_POOL_ID_FIELD, DEVELOPER_PROVIDER_NAME_FIELD, DEVELOPER_USER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnlinkDeveloperIdentityRequest.memberNameToFieldInitializer();
    private final String identityId;
    private final String identityPoolId;
    private final String developerProviderName;
    private final String developerUserIdentifier;

    private UnlinkDeveloperIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.developerProviderName = builder.developerProviderName;
        this.developerUserIdentifier = builder.developerUserIdentifier;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final String developerProviderName() {
        return this.developerProviderName;
    }

    public final String developerUserIdentifier() {
        return this.developerUserIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerUserIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkDeveloperIdentityRequest)) {
            return false;
        }
        UnlinkDeveloperIdentityRequest other = (UnlinkDeveloperIdentityRequest)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.developerProviderName(), other.developerProviderName()) && Objects.equals(this.developerUserIdentifier(), other.developerUserIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UnlinkDeveloperIdentityRequest").add("IdentityId", (Object)this.identityId()).add("IdentityPoolId", (Object)this.identityPoolId()).add("DeveloperProviderName", (Object)this.developerProviderName()).add("DeveloperUserIdentifier", (Object)this.developerUserIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "DeveloperProviderName": {
                return Optional.ofNullable(clazz.cast(this.developerProviderName()));
            }
            case "DeveloperUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.developerUserIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IdentityId", IDENTITY_ID_FIELD);
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("DeveloperProviderName", DEVELOPER_PROVIDER_NAME_FIELD);
        map.put("DeveloperUserIdentifier", DEVELOPER_USER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnlinkDeveloperIdentityRequest, T> g) {
        return obj -> g.apply((UnlinkDeveloperIdentityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityId;
        private String identityPoolId;
        private String developerProviderName;
        private String developerUserIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UnlinkDeveloperIdentityRequest model) {
            super(model);
            this.identityId(model.identityId);
            this.identityPoolId(model.identityPoolId);
            this.developerProviderName(model.developerProviderName);
            this.developerUserIdentifier(model.developerUserIdentifier);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final String getDeveloperUserIdentifier() {
            return this.developerUserIdentifier;
        }

        public final void setDeveloperUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
        }

        @Override
        public final Builder developerUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnlinkDeveloperIdentityRequest build() {
            return new UnlinkDeveloperIdentityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
        public Builder identityId(String var1);

        public Builder identityPoolId(String var1);

        public Builder developerProviderName(String var1);

        public Builder developerUserIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

