/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RulesConfigurationTypeMarshaller {
    private static final MarshallingInfo<List> RULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rules").isBinary(false).build();
    private static final RulesConfigurationTypeMarshaller INSTANCE = new RulesConfigurationTypeMarshaller();

    private RulesConfigurationTypeMarshaller() {
    }

    public static RulesConfigurationTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RulesConfigurationType rulesConfigurationType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rulesConfigurationType, (String)"rulesConfigurationType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(rulesConfigurationType.rules(), RULES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

