/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RoleMappingMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> AMBIGUOUSROLERESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmbiguousRoleResolution").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RULESCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RulesConfiguration").isBinary(false).build();
    private static final RoleMappingMarshaller INSTANCE = new RoleMappingMarshaller();

    private RoleMappingMarshaller() {
    }

    public static RoleMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RoleMapping roleMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)roleMapping, (String)"roleMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)roleMapping.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)roleMapping.ambiguousRoleResolutionString(), AMBIGUOUSROLERESOLUTION_BINDING);
            protocolMarshaller.marshall((Object)roleMapping.rulesConfiguration(), RULESCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

