/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.time.Instant;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link IdentityDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class IdentityDescriptionMarshaller {
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").isBinary(false).build();

    private static final MarshallingInfo<List> LOGINS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logins").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();

    private static final IdentityDescriptionMarshaller INSTANCE = new IdentityDescriptionMarshaller();

    private IdentityDescriptionMarshaller() {
    }

    public static IdentityDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(IdentityDescription identityDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(identityDescription, "identityDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(identityDescription.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall(identityDescription.logins(), LOGINS_BINDING);
            protocolMarshaller.marshall(identityDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(identityDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
