/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentity.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateIdentityPoolResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateIdentityPoolResponseUnmarshaller implements Unmarshaller<CreateIdentityPoolResponse, JsonUnmarshallerContext> {

    public CreateIdentityPoolResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateIdentityPoolResponse.Builder createIdentityPoolResponseBuilder = CreateIdentityPoolResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return createIdentityPoolResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("IdentityPoolId", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.identityPoolId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IdentityPoolName", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.identityPoolName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AllowUnauthenticatedIdentities", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.allowUnauthenticatedIdentities(context.getUnmarshaller(Boolean.class)
                            .unmarshall(context));
                }
                if (context.testExpression("SupportedLoginProviders", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.supportedLoginProviders(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("DeveloperProviderName", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.developerProviderName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("OpenIdConnectProviderARNs", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.openIdConnectProviderARNs(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CognitoIdentityProviders", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.cognitoIdentityProviders(new ListUnmarshaller<CognitoIdentityProvider>(
                            CognitoIdentityProviderUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SamlProviderARNs", targetDepth)) {
                    context.nextToken();
                    createIdentityPoolResponseBuilder.samlProviderARNs(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createIdentityPoolResponseBuilder.build();
    }

    private static final CreateIdentityPoolResponseUnmarshaller INSTANCE = new CreateIdentityPoolResponseUnmarshaller();

    public static CreateIdentityPoolResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
