/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.RulesConfigurationTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RulesConfigurationType implements StructuredPojo,
        ToCopyableBuilder<RulesConfigurationType.Builder, RulesConfigurationType> {
    private final List<MappingRule> rules;

    private RulesConfigurationType(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     * <p>
     * An array of rules. You can specify up to 25 rules per identity provider.
     * </p>
     * <p>
     * Rules are evaluated in order. The first one to match specifies the role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of rules. You can specify up to 25 rules per identity provider.</p>
     *         <p>
     *         Rules are evaluated in order. The first one to match specifies the role.
     */
    public List<MappingRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesConfigurationType)) {
            return false;
        }
        RulesConfigurationType other = (RulesConfigurationType) obj;
        return Objects.equals(rules(), other.rules());
    }

    @Override
    public String toString() {
        return ToString.builder("RulesConfigurationType").add("Rules", rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rules":
            return Optional.of(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RulesConfigurationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RulesConfigurationType> {
        /**
         * <p>
         * An array of rules. You can specify up to 25 rules per identity provider.
         * </p>
         * <p>
         * Rules are evaluated in order. The first one to match specifies the role.
         * </p>
         * 
         * @param rules
         *        An array of rules. You can specify up to 25 rules per identity provider.</p>
         *        <p>
         *        Rules are evaluated in order. The first one to match specifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<MappingRule> rules);

        /**
         * <p>
         * An array of rules. You can specify up to 25 rules per identity provider.
         * </p>
         * <p>
         * Rules are evaluated in order. The first one to match specifies the role.
         * </p>
         * 
         * @param rules
         *        An array of rules. You can specify up to 25 rules per identity provider.</p>
         *        <p>
         *        Rules are evaluated in order. The first one to match specifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(MappingRule... rules);
    }

    static final class BuilderImpl implements Builder {
        private List<MappingRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesConfigurationType model) {
            rules(model.rules);
        }

        public final Collection<MappingRule.Builder> getRules() {
            return rules != null ? rules.stream().map(MappingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<MappingRule> rules) {
            this.rules = MappingRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(MappingRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<MappingRule.BuilderImpl> rules) {
            this.rules = MappingRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public RulesConfigurationType build() {
            return new RulesConfigurationType(this);
        }
    }
}
