/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMapping;
import software.amazon.awssdk.services.cognitoidentity.transform.RulesConfigurationTypeUnmarshaller;

public class RoleMappingUnmarshaller
implements Unmarshaller<RoleMapping, JsonUnmarshallerContext> {
    private static final RoleMappingUnmarshaller INSTANCE = new RoleMappingUnmarshaller();

    public RoleMapping unmarshall(JsonUnmarshallerContext context) throws Exception {
        RoleMapping.Builder roleMappingBuilder = RoleMapping.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    roleMappingBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AmbiguousRoleResolution", targetDepth)) {
                    context.nextToken();
                    roleMappingBuilder.ambiguousRoleResolution((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RulesConfiguration", targetDepth)) {
                    context.nextToken();
                    roleMappingBuilder.rulesConfiguration(RulesConfigurationTypeUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RoleMapping)roleMappingBuilder.build();
    }

    public static RoleMappingUnmarshaller getInstance() {
        return INSTANCE;
    }
}

