/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnlinkDeveloperIdentityRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
    private final String identityId;
    private final String identityPoolId;
    private final String developerProviderName;
    private final String developerUserIdentifier;

    private UnlinkDeveloperIdentityRequest(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.developerProviderName = builder.developerProviderName;
        this.developerUserIdentifier = builder.developerUserIdentifier;
    }

    public String identityId() {
        return this.identityId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String developerProviderName() {
        return this.developerProviderName;
    }

    public String developerUserIdentifier() {
        return this.developerUserIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.developerProviderName() == null ? 0 : this.developerProviderName().hashCode());
        hashCode = 31 * hashCode + (this.developerUserIdentifier() == null ? 0 : this.developerUserIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkDeveloperIdentityRequest)) {
            return false;
        }
        UnlinkDeveloperIdentityRequest other = (UnlinkDeveloperIdentityRequest)((Object)obj);
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.developerProviderName() == null ^ this.developerProviderName() == null) {
            return false;
        }
        if (other.developerProviderName() != null && !other.developerProviderName().equals(this.developerProviderName())) {
            return false;
        }
        if (other.developerUserIdentifier() == null ^ this.developerUserIdentifier() == null) {
            return false;
        }
        return other.developerUserIdentifier() == null || other.developerUserIdentifier().equals(this.developerUserIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.developerProviderName() != null) {
            sb.append("DeveloperProviderName: ").append(this.developerProviderName()).append(",");
        }
        if (this.developerUserIdentifier() != null) {
            sb.append("DeveloperUserIdentifier: ").append(this.developerUserIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "DeveloperProviderName": {
                return Optional.of(clazz.cast(this.developerProviderName()));
            }
            case "DeveloperUserIdentifier": {
                return Optional.of(clazz.cast(this.developerUserIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityId;
        private String identityPoolId;
        private String developerProviderName;
        private String developerUserIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UnlinkDeveloperIdentityRequest model) {
            this.identityId(model.identityId);
            this.identityPoolId(model.identityPoolId);
            this.developerProviderName(model.developerProviderName);
            this.developerUserIdentifier(model.developerUserIdentifier);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final String getDeveloperUserIdentifier() {
            return this.developerUserIdentifier;
        }

        @Override
        public final Builder developerUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
            return this;
        }

        public final void setDeveloperUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
        }

        public UnlinkDeveloperIdentityRequest build() {
            return new UnlinkDeveloperIdentityRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
        public Builder identityId(String var1);

        public Builder identityPoolId(String var1);

        public Builder developerProviderName(String var1);

        public Builder developerUserIdentifier(String var1);
    }
}

