/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentitiesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListIdentitiesRequest> {
    private final String identityPoolId;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean hideDisabled;

    private ListIdentitiesRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.hideDisabled = builder.hideDisabled;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Boolean hideDisabled() {
        return this.hideDisabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.hideDisabled() == null ? 0 : this.hideDisabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesRequest)) {
            return false;
        }
        ListIdentitiesRequest other = (ListIdentitiesRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.hideDisabled() == null ^ this.hideDisabled() == null) {
            return false;
        }
        return other.hideDisabled() == null || other.hideDisabled().equals(this.hideDisabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.hideDisabled() != null) {
            sb.append("HideDisabled: ").append(this.hideDisabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "HideDisabled": {
                return Optional.of(clazz.cast(this.hideDisabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Integer maxResults;
        private String nextToken;
        private Boolean hideDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.hideDisabled(model.hideDisabled);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getHideDisabled() {
            return this.hideDisabled;
        }

        @Override
        public final Builder hideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
            return this;
        }

        public final void setHideDisabled(Boolean hideDisabled) {
            this.hideDisabled = hideDisabled;
        }

        public ListIdentitiesRequest build() {
            return new ListIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIdentitiesRequest> {
        public Builder identityPoolId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder hideDisabled(Boolean var1);
    }
}

