/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>UnlinkDeveloperIdentity</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnlinkDeveloperIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UnlinkDeveloperIdentityRequest.Builder, UnlinkDeveloperIdentityRequest> {
    private final String identityId;

    private final String identityPoolId;

    private final String developerProviderName;

    private final String developerUserIdentifier;

    private UnlinkDeveloperIdentityRequest(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.developerProviderName = builder.developerProviderName;
        this.developerUserIdentifier = builder.developerUserIdentifier;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The "domain" by which Cognito will refer to your users.
     * </p>
     * 
     * @return The "domain" by which Cognito will refer to your users.
     */
    public String developerProviderName() {
        return developerProviderName;
    }

    /**
     * <p>
     * A unique ID used by your backend authentication process to identify a user.
     * </p>
     * 
     * @return A unique ID used by your backend authentication process to identify a user.
     */
    public String developerUserIdentifier() {
        return developerUserIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((identityPoolId() == null) ? 0 : identityPoolId().hashCode());
        hashCode = 31 * hashCode + ((developerProviderName() == null) ? 0 : developerProviderName().hashCode());
        hashCode = 31 * hashCode + ((developerUserIdentifier() == null) ? 0 : developerUserIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkDeveloperIdentityRequest)) {
            return false;
        }
        UnlinkDeveloperIdentityRequest other = (UnlinkDeveloperIdentityRequest) obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.developerProviderName() == null ^ this.developerProviderName() == null) {
            return false;
        }
        if (other.developerProviderName() != null && !other.developerProviderName().equals(this.developerProviderName())) {
            return false;
        }
        if (other.developerUserIdentifier() == null ^ this.developerUserIdentifier() == null) {
            return false;
        }
        if (other.developerUserIdentifier() != null && !other.developerUserIdentifier().equals(this.developerUserIdentifier())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (developerProviderName() != null) {
            sb.append("DeveloperProviderName: ").append(developerProviderName()).append(",");
        }
        if (developerUserIdentifier() != null) {
            sb.append("DeveloperUserIdentifier: ").append(developerUserIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.of(clazz.cast(identityId()));
        case "IdentityPoolId":
            return Optional.of(clazz.cast(identityPoolId()));
        case "DeveloperProviderName":
            return Optional.of(clazz.cast(developerProviderName()));
        case "DeveloperUserIdentifier":
            return Optional.of(clazz.cast(developerUserIdentifier()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The "domain" by which Cognito will refer to your users.
         * </p>
         * 
         * @param developerProviderName
         *        The "domain" by which Cognito will refer to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerProviderName(String developerProviderName);

        /**
         * <p>
         * A unique ID used by your backend authentication process to identify a user.
         * </p>
         * 
         * @param developerUserIdentifier
         *        A unique ID used by your backend authentication process to identify a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerUserIdentifier(String developerUserIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String identityId;

        private String identityPoolId;

        private String developerProviderName;

        private String developerUserIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UnlinkDeveloperIdentityRequest model) {
            identityId(model.identityId);
            identityPoolId(model.identityPoolId);
            developerProviderName(model.developerProviderName);
            developerUserIdentifier(model.developerUserIdentifier);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getDeveloperProviderName() {
            return developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final String getDeveloperUserIdentifier() {
            return developerUserIdentifier;
        }

        @Override
        public final Builder developerUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
            return this;
        }

        public final void setDeveloperUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
        }

        @Override
        public UnlinkDeveloperIdentityRequest build() {
            return new UnlinkDeveloperIdentityRequest(this);
        }
    }
}
