/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.RoleMappingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A role mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RoleMapping implements StructuredPojo, ToCopyableBuilder<RoleMapping.Builder, RoleMapping> {
    private final String type;

    private final String ambiguousRoleResolution;

    private final RulesConfigurationType rulesConfiguration;

    private RoleMapping(BuilderImpl builder) {
        this.type = builder.type;
        this.ambiguousRoleResolution = builder.ambiguousRoleResolution;
        this.rulesConfiguration = builder.rulesConfiguration;
    }

    /**
     * <p>
     * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims
     * from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims from the
     * token to map to a role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RoleMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
     *         claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match
     *         claims from the token to map to a role.
     * @see RoleMappingType
     */
    public RoleMappingType type() {
        return RoleMappingType.fromValue(type);
    }

    /**
     * <p>
     * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims
     * from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims from the
     * token to map to a role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RoleMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
     *         claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match
     *         claims from the token to map to a role.
     * @see RoleMappingType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
     * </p>
     * <p>
     * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
     * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code> matches
     * for the <code>Token</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ambiguousRoleResolution} will return {@link AmbiguousRoleResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ambiguousRoleResolutionString}.
     * </p>
     * 
     * @return If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
     *         required.</p>
     *         <p>
     *         Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
     *         type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
     *         <code>cognito:roles</code> matches for the <code>Token</code> type.
     * @see AmbiguousRoleResolutionType
     */
    public AmbiguousRoleResolutionType ambiguousRoleResolution() {
        return AmbiguousRoleResolutionType.fromValue(ambiguousRoleResolution);
    }

    /**
     * <p>
     * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
     * </p>
     * <p>
     * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
     * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code> matches
     * for the <code>Token</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ambiguousRoleResolution} will return {@link AmbiguousRoleResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ambiguousRoleResolutionString}.
     * </p>
     * 
     * @return If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
     *         required.</p>
     *         <p>
     *         Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
     *         type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
     *         <code>cognito:roles</code> matches for the <code>Token</code> type.
     * @see AmbiguousRoleResolutionType
     */
    public String ambiguousRoleResolutionString() {
        return ambiguousRoleResolution;
    }

    /**
     * <p>
     * The rules to be used for mapping users to roles.
     * </p>
     * <p>
     * If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
     * </p>
     * 
     * @return The rules to be used for mapping users to roles.</p>
     *         <p>
     *         If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
     */
    public RulesConfigurationType rulesConfiguration() {
        return rulesConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((ambiguousRoleResolutionString() == null) ? 0 : ambiguousRoleResolutionString().hashCode());
        hashCode = 31 * hashCode + ((rulesConfiguration() == null) ? 0 : rulesConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleMapping)) {
            return false;
        }
        RoleMapping other = (RoleMapping) obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.ambiguousRoleResolutionString() == null ^ this.ambiguousRoleResolutionString() == null) {
            return false;
        }
        if (other.ambiguousRoleResolutionString() != null
                && !other.ambiguousRoleResolutionString().equals(this.ambiguousRoleResolutionString())) {
            return false;
        }
        if (other.rulesConfiguration() == null ^ this.rulesConfiguration() == null) {
            return false;
        }
        if (other.rulesConfiguration() != null && !other.rulesConfiguration().equals(this.rulesConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (ambiguousRoleResolutionString() != null) {
            sb.append("AmbiguousRoleResolution: ").append(ambiguousRoleResolutionString()).append(",");
        }
        if (rulesConfiguration() != null) {
            sb.append("RulesConfiguration: ").append(rulesConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "AmbiguousRoleResolution":
            return Optional.of(clazz.cast(ambiguousRoleResolutionString()));
        case "RulesConfiguration":
            return Optional.of(clazz.cast(rulesConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoleMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RoleMapping> {
        /**
         * <p>
         * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
         * claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims
         * from the token to map to a role.
         * </p>
         * 
         * @param type
         *        The role mapping type. Token will use <code>cognito:roles</code> and
         *        <code>cognito:preferred_role</code> claims from the Cognito identity provider token to map groups to
         *        roles. Rules will attempt to match claims from the token to map to a role.
         * @see RoleMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleMappingType
         */
        Builder type(String type);

        /**
         * <p>
         * The role mapping type. Token will use <code>cognito:roles</code> and <code>cognito:preferred_role</code>
         * claims from the Cognito identity provider token to map groups to roles. Rules will attempt to match claims
         * from the token to map to a role.
         * </p>
         * 
         * @param type
         *        The role mapping type. Token will use <code>cognito:roles</code> and
         *        <code>cognito:preferred_role</code> claims from the Cognito identity provider token to map groups to
         *        roles. Rules will attempt to match claims from the token to map to a role.
         * @see RoleMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleMappingType
         */
        Builder type(RoleMappingType type);

        /**
         * <p>
         * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
         * </p>
         * <p>
         * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
         * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code>
         * matches for the <code>Token</code> type.
         * </p>
         * 
         * @param ambiguousRoleResolution
         *        If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
         *        required.</p>
         *        <p>
         *        Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
         *        type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
         *        <code>cognito:roles</code> matches for the <code>Token</code> type.
         * @see AmbiguousRoleResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmbiguousRoleResolutionType
         */
        Builder ambiguousRoleResolution(String ambiguousRoleResolution);

        /**
         * <p>
         * If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is required.
         * </p>
         * <p>
         * Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code> type, or
         * there is no <code>cognito:preferred_role</code> claim and there are multiple <code>cognito:roles</code>
         * matches for the <code>Token</code> type.
         * </p>
         * 
         * @param ambiguousRoleResolution
         *        If you specify Token or Rules as the <code>Type</code>, <code>AmbiguousRoleResolution</code> is
         *        required.</p>
         *        <p>
         *        Specifies the action to be taken if either no rules match the claim value for the <code>Rules</code>
         *        type, or there is no <code>cognito:preferred_role</code> claim and there are multiple
         *        <code>cognito:roles</code> matches for the <code>Token</code> type.
         * @see AmbiguousRoleResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmbiguousRoleResolutionType
         */
        Builder ambiguousRoleResolution(AmbiguousRoleResolutionType ambiguousRoleResolution);

        /**
         * <p>
         * The rules to be used for mapping users to roles.
         * </p>
         * <p>
         * If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
         * </p>
         * 
         * @param rulesConfiguration
         *        The rules to be used for mapping users to roles.</p>
         *        <p>
         *        If you specify Rules as the role mapping type, <code>RulesConfiguration</code> is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesConfiguration(RulesConfigurationType rulesConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String ambiguousRoleResolution;

        private RulesConfigurationType rulesConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleMapping model) {
            type(model.type);
            ambiguousRoleResolution(model.ambiguousRoleResolution);
            rulesConfiguration(model.rulesConfiguration);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoleMappingType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAmbiguousRoleResolution() {
            return ambiguousRoleResolution;
        }

        @Override
        public final Builder ambiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
            return this;
        }

        @Override
        public final Builder ambiguousRoleResolution(AmbiguousRoleResolutionType ambiguousRoleResolution) {
            this.ambiguousRoleResolution(ambiguousRoleResolution.toString());
            return this;
        }

        public final void setAmbiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
        }

        public final RulesConfigurationType.Builder getRulesConfiguration() {
            return rulesConfiguration != null ? rulesConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rulesConfiguration(RulesConfigurationType rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration;
            return this;
        }

        public final void setRulesConfiguration(RulesConfigurationType.BuilderImpl rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration != null ? rulesConfiguration.build() : null;
        }

        @Override
        public RoleMapping build() {
            return new RoleMapping(this);
        }
    }
}
