/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.CognitoIdentityProviderMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A provider representing an Amazon Cognito Identity User Pool and its client ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CognitoIdentityProvider implements StructuredPojo,
        ToCopyableBuilder<CognitoIdentityProvider.Builder, CognitoIdentityProvider> {
    private final String providerName;

    private final String clientId;

    private final Boolean serverSideTokenCheck;

    private CognitoIdentityProvider(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.clientId = builder.clientId;
        this.serverSideTokenCheck = builder.serverSideTokenCheck;
    }

    /**
     * <p>
     * The provider name for an Amazon Cognito Identity User Pool. For example,
     * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     * </p>
     * 
     * @return The provider name for an Amazon Cognito Identity User Pool. For example,
     *         <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
     */
    public String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The client ID for the Amazon Cognito Identity User Pool.
     * </p>
     * 
     * @return The client ID for the Amazon Cognito Identity User Pool.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * TRUE if server-side token validation is enabled for the identity provider’s token.
     * </p>
     * 
     * @return TRUE if server-side token validation is enabled for the identity provider’s token.
     */
    public Boolean serverSideTokenCheck() {
        return serverSideTokenCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((providerName() == null) ? 0 : providerName().hashCode());
        hashCode = 31 * hashCode + ((clientId() == null) ? 0 : clientId().hashCode());
        hashCode = 31 * hashCode + ((serverSideTokenCheck() == null) ? 0 : serverSideTokenCheck().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoIdentityProvider)) {
            return false;
        }
        CognitoIdentityProvider other = (CognitoIdentityProvider) obj;
        if (other.providerName() == null ^ this.providerName() == null) {
            return false;
        }
        if (other.providerName() != null && !other.providerName().equals(this.providerName())) {
            return false;
        }
        if (other.clientId() == null ^ this.clientId() == null) {
            return false;
        }
        if (other.clientId() != null && !other.clientId().equals(this.clientId())) {
            return false;
        }
        if (other.serverSideTokenCheck() == null ^ this.serverSideTokenCheck() == null) {
            return false;
        }
        if (other.serverSideTokenCheck() != null && !other.serverSideTokenCheck().equals(this.serverSideTokenCheck())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (providerName() != null) {
            sb.append("ProviderName: ").append(providerName()).append(",");
        }
        if (clientId() != null) {
            sb.append("ClientId: ").append(clientId()).append(",");
        }
        if (serverSideTokenCheck() != null) {
            sb.append("ServerSideTokenCheck: ").append(serverSideTokenCheck()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.of(clazz.cast(providerName()));
        case "ClientId":
            return Optional.of(clazz.cast(clientId()));
        case "ServerSideTokenCheck":
            return Optional.of(clazz.cast(serverSideTokenCheck()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoIdentityProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CognitoIdentityProvider> {
        /**
         * <p>
         * The provider name for an Amazon Cognito Identity User Pool. For example,
         * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         * </p>
         * 
         * @param providerName
         *        The provider name for an Amazon Cognito Identity User Pool. For example,
         *        <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The client ID for the Amazon Cognito Identity User Pool.
         * </p>
         * 
         * @param clientId
         *        The client ID for the Amazon Cognito Identity User Pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * TRUE if server-side token validation is enabled for the identity provider’s token.
         * </p>
         * 
         * @param serverSideTokenCheck
         *        TRUE if server-side token validation is enabled for the identity provider’s token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideTokenCheck(Boolean serverSideTokenCheck);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String clientId;

        private Boolean serverSideTokenCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoIdentityProvider model) {
            providerName(model.providerName);
            clientId(model.clientId);
            serverSideTokenCheck(model.serverSideTokenCheck);
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final Boolean getServerSideTokenCheck() {
            return serverSideTokenCheck;
        }

        @Override
        public final Builder serverSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
            return this;
        }

        public final void setServerSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
        }

        @Override
        public CognitoIdentityProvider build() {
            return new CognitoIdentityProvider(this);
        }
    }
}
