/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOpenIdTokenForDeveloperIdentityRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
    private final String identityPoolId;
    private final String identityId;
    private final Map<String, String> logins;
    private final Long tokenDuration;

    private GetOpenIdTokenForDeveloperIdentityRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.tokenDuration = builder.tokenDuration;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public Map<String, String> logins() {
        return this.logins;
    }

    public Long tokenDuration() {
        return this.tokenDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.logins() == null ? 0 : this.logins().hashCode());
        hashCode = 31 * hashCode + (this.tokenDuration() == null ? 0 : this.tokenDuration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenForDeveloperIdentityRequest)) {
            return false;
        }
        GetOpenIdTokenForDeveloperIdentityRequest other = (GetOpenIdTokenForDeveloperIdentityRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        if (other.tokenDuration() == null ^ this.tokenDuration() == null) {
            return false;
        }
        return other.tokenDuration() == null || other.tokenDuration().equals(this.tokenDuration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.logins() != null) {
            sb.append("Logins: ").append(this.logins()).append(",");
        }
        if (this.tokenDuration() != null) {
            sb.append("TokenDuration: ").append(this.tokenDuration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private Map<String, String> logins;
        private Long tokenDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenForDeveloperIdentityRequest model) {
            this.setIdentityPoolId(model.identityPoolId);
            this.setIdentityId(model.identityId);
            this.setLogins(model.logins);
            this.setTokenDuration(model.tokenDuration);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public final Long getTokenDuration() {
            return this.tokenDuration;
        }

        @Override
        public final Builder tokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
            return this;
        }

        public final void setTokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
        }

        public GetOpenIdTokenForDeveloperIdentityRequest build() {
            return new GetOpenIdTokenForDeveloperIdentityRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder logins(Map<String, String> var1);

        public Builder tokenDuration(Long var1);
    }
}

