/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a successful ListIdentityPools action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentityPoolsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListIdentityPoolsResponse.Builder, ListIdentityPoolsResponse> {
    private final List<IdentityPoolShortDescription> identityPools;

    private final String nextToken;

    private ListIdentityPoolsResponse(BuilderImpl builder) {
        this.identityPools = builder.identityPools;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identity pools returned by the ListIdentityPools action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The identity pools returned by the ListIdentityPools action.
     */
    public List<IdentityPoolShortDescription> identityPools() {
        return identityPools;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityPools() == null) ? 0 : identityPools().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResponse)) {
            return false;
        }
        ListIdentityPoolsResponse other = (ListIdentityPoolsResponse) obj;
        if (other.identityPools() == null ^ this.identityPools() == null) {
            return false;
        }
        if (other.identityPools() != null && !other.identityPools().equals(this.identityPools())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityPools() != null) {
            sb.append("IdentityPools: ").append(identityPools()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListIdentityPoolsResponse> {
        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * 
         * @param identityPools
         *        The identity pools returned by the ListIdentityPools action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPools(Collection<IdentityPoolShortDescription> identityPools);

        /**
         * <p>
         * The identity pools returned by the ListIdentityPools action.
         * </p>
         * 
         * @param identityPools
         *        The identity pools returned by the ListIdentityPools action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPools(IdentityPoolShortDescription... identityPools);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<IdentityPoolShortDescription> identityPools;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolsResponse model) {
            setIdentityPools(model.identityPools);
            setNextToken(model.nextToken);
        }

        public final Collection<IdentityPoolShortDescription> getIdentityPools() {
            return identityPools;
        }

        @Override
        public final Builder identityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(IdentityPoolShortDescription... identityPools) {
            identityPools(Arrays.asList(identityPools));
            return this;
        }

        public final void setIdentityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentityPoolsResponse build() {
            return new ListIdentityPoolsResponse(this);
        }
    }
}
