/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.UnprocessedIdentityIdMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of UnprocessedIdentityId objects, each of which contains an ErrorCode and IdentityId.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UnprocessedIdentityId implements StructuredPojo,
        ToCopyableBuilder<UnprocessedIdentityId.Builder, UnprocessedIdentityId> {
    private final String identityId;

    private final String errorCode;

    private UnprocessedIdentityId(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.errorCode = builder.errorCode;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * The error code indicating the type of error that occurred.
     * </p>
     * 
     * @return The error code indicating the type of error that occurred.
     * @see ErrorCode
     */
    public String errorCode() {
        return errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((errorCode() == null) ? 0 : errorCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedIdentityId)) {
            return false;
        }
        UnprocessedIdentityId other = (UnprocessedIdentityId) obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnprocessedIdentityIdMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UnprocessedIdentityId> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * The error code indicating the type of error that occurred.
         * </p>
         * 
         * @param errorCode
         *        The error code indicating the type of error that occurred.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code indicating the type of error that occurred.
         * </p>
         * 
         * @param errorCode
         *        The error code indicating the type of error that occurred.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(ErrorCode errorCode);
    }

    private static final class BuilderImpl implements Builder {
        private String identityId;

        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedIdentityId model) {
            setIdentityId(model.identityId);
            setErrorCode(model.errorCode);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final void setErrorCode(ErrorCode errorCode) {
            this.errorCode(errorCode.toString());
        }

        @Override
        public UnprocessedIdentityId build() {
            return new UnprocessedIdentityId(this);
        }
    }
}
