/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>LookupDeveloperIdentity</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LookupDeveloperIdentityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<LookupDeveloperIdentityResponse.Builder, LookupDeveloperIdentityResponse> {
    private final String identityId;

    private final List<String> developerUserIdentifierList;

    private final String nextToken;

    private LookupDeveloperIdentityResponse(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.developerUserIdentifierList = builder.developerUserIdentifierList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * This is the list of developer user identifiers associated with an identity ID. Cognito supports the association
     * of multiple developer user identifiers with an identity ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This is the list of developer user identifiers associated with an identity ID. Cognito supports the
     *         association of multiple developer user identifiers with an identity ID.
     */
    public List<String> developerUserIdentifierList() {
        return developerUserIdentifierList;
    }

    /**
     * <p>
     * A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service
     * will return <code>NextToken</code> values as needed. For example, let's say you make a request with
     * <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination
     * token as a part of the response. This token can be used to call the API again and get results starting from the
     * 11th match.
     * </p>
     * 
     * @return A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the
     *         service will return <code>NextToken</code> values as needed. For example, let's say you make a request
     *         with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return
     *         a pagination token as a part of the response. This token can be used to call the API again and get
     *         results starting from the 11th match.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityId() == null) ? 0 : identityId().hashCode());
        hashCode = 31 * hashCode + ((developerUserIdentifierList() == null) ? 0 : developerUserIdentifierList().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupDeveloperIdentityResponse)) {
            return false;
        }
        LookupDeveloperIdentityResponse other = (LookupDeveloperIdentityResponse) obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.developerUserIdentifierList() == null ^ this.developerUserIdentifierList() == null) {
            return false;
        }
        if (other.developerUserIdentifierList() != null
                && !other.developerUserIdentifierList().equals(this.developerUserIdentifierList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityId() != null) {
            sb.append("IdentityId: ").append(identityId()).append(",");
        }
        if (developerUserIdentifierList() != null) {
            sb.append("DeveloperUserIdentifierList: ").append(developerUserIdentifierList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LookupDeveloperIdentityResponse> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * This is the list of developer user identifiers associated with an identity ID. Cognito supports the
         * association of multiple developer user identifiers with an identity ID.
         * </p>
         * 
         * @param developerUserIdentifierList
         *        This is the list of developer user identifiers associated with an identity ID. Cognito supports the
         *        association of multiple developer user identifiers with an identity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerUserIdentifierList(Collection<String> developerUserIdentifierList);

        /**
         * <p>
         * This is the list of developer user identifiers associated with an identity ID. Cognito supports the
         * association of multiple developer user identifiers with an identity ID.
         * </p>
         * 
         * @param developerUserIdentifierList
         *        This is the list of developer user identifiers associated with an identity ID. Cognito supports the
         *        association of multiple developer user identifiers with an identity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerUserIdentifierList(String... developerUserIdentifierList);

        /**
         * <p>
         * A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the
         * service will return <code>NextToken</code> values as needed. For example, let's say you make a request with
         * <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a
         * pagination token as a part of the response. This token can be used to call the API again and get results
         * starting from the 11th match.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. The first call you make will have <code>NextToken</code> set to null. After that
         *        the service will return <code>NextToken</code> values as needed. For example, let's say you make a
         *        request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service
         *        will return a pagination token as a part of the response. This token can be used to call the API again
         *        and get results starting from the 11th match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String identityId;

        private List<String> developerUserIdentifierList;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupDeveloperIdentityResponse model) {
            setIdentityId(model.identityId);
            setDeveloperUserIdentifierList(model.developerUserIdentifierList);
            setNextToken(model.nextToken);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getDeveloperUserIdentifierList() {
            return developerUserIdentifierList;
        }

        @Override
        public final Builder developerUserIdentifierList(Collection<String> developerUserIdentifierList) {
            this.developerUserIdentifierList = DeveloperUserIdentifierListCopier.copy(developerUserIdentifierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder developerUserIdentifierList(String... developerUserIdentifierList) {
            developerUserIdentifierList(Arrays.asList(developerUserIdentifierList));
            return this;
        }

        public final void setDeveloperUserIdentifierList(Collection<String> developerUserIdentifierList) {
            this.developerUserIdentifierList = DeveloperUserIdentifierListCopier.copy(developerUserIdentifierList);
        }

        @SafeVarargs
        public final void setDeveloperUserIdentifierList(String... developerUserIdentifierList) {
            developerUserIdentifierList(Arrays.asList(developerUserIdentifierList));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public LookupDeveloperIdentityResponse build() {
            return new LookupDeveloperIdentityResponse(this);
        }
    }
}
