/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.Credentials;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Credentials} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessKeyId").isBinary(false).build();

    private static final MarshallingInfo<String> SECRETKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretKey").isBinary(false).build();

    private static final MarshallingInfo<String> SESSIONTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionToken").isBinary(false).build();

    private static final MarshallingInfo<Instant> EXPIRATION_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expiration").isBinary(false).build();

    private static final CredentialsMarshaller INSTANCE = new CredentialsMarshaller();

    private CredentialsMarshaller() {
    }

    public static CredentialsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Credentials credentials, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(credentials, "credentials");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(credentials.accessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall(credentials.secretKey(), SECRETKEY_BINDING);
            protocolMarshaller.marshall(credentials.sessionToken(), SESSIONTOKEN_BINDING);
            protocolMarshaller.marshall(credentials.expiration(), EXPIRATION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
