/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>MergeDeveloperIdentities</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeDeveloperIdentitiesResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<MergeDeveloperIdentitiesResponse.Builder, MergeDeveloperIdentitiesResponse> {
    private final String identityId;

    private MergeDeveloperIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeDeveloperIdentitiesResponse)) {
            return false;
        }
        MergeDeveloperIdentitiesResponse other = (MergeDeveloperIdentitiesResponse) obj;
        return Objects.equals(identityId(), other.identityId());
    }

    @Override
    public String toString() {
        return ToString.builder("MergeDeveloperIdentitiesResponse").add("IdentityId", identityId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityResponse.Builder, CopyableBuilder<Builder, MergeDeveloperIdentitiesResponse> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeDeveloperIdentitiesResponse model) {
            super(model);
            identityId(model.identityId);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public MergeDeveloperIdentitiesResponse build() {
            return new MergeDeveloperIdentitiesResponse(this);
        }
    }
}
