/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UnlinkDeveloperIdentityRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UnlinkDeveloperIdentityRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").isBinary(false).build();

    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> DEVELOPERPROVIDERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeveloperProviderName").isBinary(false).build();

    private static final MarshallingInfo<String> DEVELOPERUSERIDENTIFIER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeveloperUserIdentifier").isBinary(false).build();

    private static final UnlinkDeveloperIdentityRequestModelMarshaller INSTANCE = new UnlinkDeveloperIdentityRequestModelMarshaller();

    private UnlinkDeveloperIdentityRequestModelMarshaller() {
    }

    public static UnlinkDeveloperIdentityRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UnlinkDeveloperIdentityRequest unlinkDeveloperIdentityRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(unlinkDeveloperIdentityRequest, "unlinkDeveloperIdentityRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(unlinkDeveloperIdentityRequest.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall(unlinkDeveloperIdentityRequest.identityPoolId(), IDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall(unlinkDeveloperIdentityRequest.developerProviderName(), DEVELOPERPROVIDERNAME_BINDING);
            protocolMarshaller
                    .marshall(unlinkDeveloperIdentityRequest.developerUserIdentifier(), DEVELOPERUSERIDENTIFIER_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
