/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateIdentityPoolRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateIdentityPoolRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYPOOLNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolName").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ALLOWUNAUTHENTICATEDIDENTITIES_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AllowUnauthenticatedIdentities").isBinary(false).build();

    private static final MarshallingInfo<Map> SUPPORTEDLOGINPROVIDERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedLoginProviders").isBinary(false).build();

    private static final MarshallingInfo<String> DEVELOPERPROVIDERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeveloperProviderName").isBinary(false).build();

    private static final MarshallingInfo<List> OPENIDCONNECTPROVIDERARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OpenIdConnectProviderARNs").isBinary(false).build();

    private static final MarshallingInfo<List> COGNITOIDENTITYPROVIDERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CognitoIdentityProviders").isBinary(false).build();

    private static final MarshallingInfo<List> SAMLPROVIDERARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SamlProviderARNs").isBinary(false).build();

    private static final CreateIdentityPoolRequestModelMarshaller INSTANCE = new CreateIdentityPoolRequestModelMarshaller();

    private CreateIdentityPoolRequestModelMarshaller() {
    }

    public static CreateIdentityPoolRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateIdentityPoolRequest createIdentityPoolRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createIdentityPoolRequest, "createIdentityPoolRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createIdentityPoolRequest.identityPoolName(), IDENTITYPOOLNAME_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.allowUnauthenticatedIdentities(),
                    ALLOWUNAUTHENTICATEDIDENTITIES_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.supportedLoginProviders(), SUPPORTEDLOGINPROVIDERS_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.developerProviderName(), DEVELOPERPROVIDERNAME_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.openIdConnectProviderARNs(), OPENIDCONNECTPROVIDERARNS_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.cognitoIdentityProviders(), COGNITOIDENTITYPROVIDERS_BINDING);
            protocolMarshaller.marshall(createIdentityPoolRequest.samlProviderARNs(), SAMLPROVIDERARNS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
