/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId;
import software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteIdentitiesResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, DeleteIdentitiesResponse> {
    private final List<UnprocessedIdentityId> unprocessedIdentityIds;

    private DeleteIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedIdentityIds = builder.unprocessedIdentityIds;
    }

    public List<UnprocessedIdentityId> unprocessedIdentityIds() {
        return this.unprocessedIdentityIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedIdentityIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesResponse)) {
            return false;
        }
        DeleteIdentitiesResponse other = (DeleteIdentitiesResponse)((Object)obj);
        return Objects.equals(this.unprocessedIdentityIds(), other.unprocessedIdentityIds());
    }

    public String toString() {
        return ToString.builder((String)"DeleteIdentitiesResponse").add("UnprocessedIdentityIds", this.unprocessedIdentityIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedIdentityIds": {
                return Optional.of(clazz.cast(this.unprocessedIdentityIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private List<UnprocessedIdentityId> unprocessedIdentityIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesResponse model) {
            super(model);
            this.unprocessedIdentityIds(model.unprocessedIdentityIds);
        }

        public final Collection<UnprocessedIdentityId.Builder> getUnprocessedIdentityIds() {
            return this.unprocessedIdentityIds != null ? (Collection)this.unprocessedIdentityIds.stream().map(UnprocessedIdentityId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copy(unprocessedIdentityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(UnprocessedIdentityId ... unprocessedIdentityIds) {
            this.unprocessedIdentityIds(Arrays.asList(unprocessedIdentityIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(Consumer<UnprocessedIdentityId.Builder> ... unprocessedIdentityIds) {
            this.unprocessedIdentityIds(Stream.of(unprocessedIdentityIds).map(c -> (UnprocessedIdentityId)((UnprocessedIdentityId.Builder)UnprocessedIdentityId.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedIdentityIds(Collection<UnprocessedIdentityId.BuilderImpl> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copyFromBuilder(unprocessedIdentityIds);
        }

        @Override
        public DeleteIdentitiesResponse build() {
            return new DeleteIdentitiesResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    CopyableBuilder<Builder, DeleteIdentitiesResponse> {
        public Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> var1);

        public Builder unprocessedIdentityIds(UnprocessedIdentityId ... var1);

        public Builder unprocessedIdentityIds(Consumer<UnprocessedIdentityId.Builder> ... var1);
    }
}

