/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetOpenIdTokenForDeveloperIdentityRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").isBinary(false).build();

    private static final MarshallingInfo<Map> LOGINS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logins").isBinary(false).build();

    private static final MarshallingInfo<Long> TOKENDURATION_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenDuration").isBinary(false).build();

    private static final GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller INSTANCE = new GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller();

    private GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller() {
    }

    public static GetOpenIdTokenForDeveloperIdentityRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getOpenIdTokenForDeveloperIdentityRequest, "getOpenIdTokenForDeveloperIdentityRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.identityPoolId(), IDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.logins(), LOGINS_BINDING);
            protocolMarshaller.marshall(getOpenIdTokenForDeveloperIdentityRequest.tokenDuration(), TOKENDURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
