/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>GetIdentityPoolRoles</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityPoolRolesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetIdentityPoolRolesResponse.Builder, GetIdentityPoolRolesResponse> {
    private final String identityPoolId;

    private final Map<String, String> roles;

    private final Map<String, RoleMapping> roleMappings;

    private GetIdentityPoolRolesResponse(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.roles = builder.roles;
        this.roleMappings = builder.roleMappings;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are supported.
     * </p>
     * 
     * @return The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
     *         supported.
     */
    public Map<String, String> roles() {
        return roles;
    }

    /**
     * <p>
     * How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a> object
     * map. The string identifies the identity provider, for example, "graph.facebook.com" or
     * "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
     * </p>
     * 
     * @return How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a>
     *         object map. The string identifies the identity provider, for example, "graph.facebook.com" or
     *         "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
     */
    public Map<String, RoleMapping> roleMappings() {
        return roleMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityPoolId() == null) ? 0 : identityPoolId().hashCode());
        hashCode = 31 * hashCode + ((roles() == null) ? 0 : roles().hashCode());
        hashCode = 31 * hashCode + ((roleMappings() == null) ? 0 : roleMappings().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoolRolesResponse)) {
            return false;
        }
        GetIdentityPoolRolesResponse other = (GetIdentityPoolRolesResponse) obj;
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.roles() == null ^ this.roles() == null) {
            return false;
        }
        if (other.roles() != null && !other.roles().equals(this.roles())) {
            return false;
        }
        if (other.roleMappings() == null ^ this.roleMappings() == null) {
            return false;
        }
        if (other.roleMappings() != null && !other.roleMappings().equals(this.roleMappings())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(identityPoolId()).append(",");
        }
        if (roles() != null) {
            sb.append("Roles: ").append(roles()).append(",");
        }
        if (roleMappings() != null) {
            sb.append("RoleMappings: ").append(roleMappings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityPoolRolesResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
         * supported.
         * </p>
         * 
         * @param roles
         *        The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Map<String, String> roles);

        /**
         * <p>
         * How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a>
         * object map. The string identifies the identity provider, for example, "graph.facebook.com" or
         * "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         * </p>
         * 
         * @param roleMappings
         *        How users for a specific identity provider are to mapped to roles. This is a
         *        String-to-<a>RoleMapping</a> object map. The string identifies the identity provider, for example,
         *        "graph.facebook.com" or "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleMappings(Map<String, RoleMapping> roleMappings);
    }

    private static final class BuilderImpl implements Builder {
        private String identityPoolId;

        private Map<String, String> roles;

        private Map<String, RoleMapping> roleMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoolRolesResponse model) {
            setIdentityPoolId(model.identityPoolId);
            setRoles(model.roles);
            setRoleMappings(model.roleMappings);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getRoles() {
            return roles;
        }

        @Override
        public final Builder roles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
            return this;
        }

        public final void setRoles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
        }

        public final Map<String, RoleMapping> getRoleMappings() {
            return roleMappings;
        }

        @Override
        public final Builder roleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
            return this;
        }

        public final void setRoleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
        }

        @Override
        public GetIdentityPoolRolesResponse build() {
            return new GetIdentityPoolRolesResponse(this);
        }
    }
}
