/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cognitoidentity.transform.CredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Credentials for the provided identity ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Credentials implements StructuredPojo, ToCopyableBuilder<Credentials.Builder, Credentials> {
    private final String accessKeyId;

    private final String secretKey;

    private final String sessionToken;

    private final Date expiration;

    private Credentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretKey = builder.secretKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * The Access Key portion of the credentials.
     * </p>
     * 
     * @return The Access Key portion of the credentials.
     */
    public String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The Secret Access Key portion of the credentials
     * </p>
     * 
     * @return The Secret Access Key portion of the credentials
     */
    public String secretKey() {
        return secretKey;
    }

    /**
     * <p>
     * The Session Token portion of the credentials
     * </p>
     * 
     * @return The Session Token portion of the credentials
     */
    public String sessionToken() {
        return sessionToken;
    }

    /**
     * <p>
     * The date at which these credentials will expire.
     * </p>
     * 
     * @return The date at which these credentials will expire.
     */
    public Date expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accessKeyId() == null) ? 0 : accessKeyId().hashCode());
        hashCode = 31 * hashCode + ((secretKey() == null) ? 0 : secretKey().hashCode());
        hashCode = 31 * hashCode + ((sessionToken() == null) ? 0 : sessionToken().hashCode());
        hashCode = 31 * hashCode + ((expiration() == null) ? 0 : expiration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials) obj;
        if (other.accessKeyId() == null ^ this.accessKeyId() == null) {
            return false;
        }
        if (other.accessKeyId() != null && !other.accessKeyId().equals(this.accessKeyId())) {
            return false;
        }
        if (other.secretKey() == null ^ this.secretKey() == null) {
            return false;
        }
        if (other.secretKey() != null && !other.secretKey().equals(this.secretKey())) {
            return false;
        }
        if (other.sessionToken() == null ^ this.sessionToken() == null) {
            return false;
        }
        if (other.sessionToken() != null && !other.sessionToken().equals(this.sessionToken())) {
            return false;
        }
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(accessKeyId()).append(",");
        }
        if (secretKey() != null) {
            sb.append("SecretKey: ").append(secretKey()).append(",");
        }
        if (sessionToken() != null) {
            sb.append("SessionToken: ").append(sessionToken()).append(",");
        }
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Credentials> {
        /**
         * <p>
         * The Access Key portion of the credentials.
         * </p>
         * 
         * @param accessKeyId
         *        The Access Key portion of the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The Secret Access Key portion of the credentials
         * </p>
         * 
         * @param secretKey
         *        The Secret Access Key portion of the credentials
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretKey(String secretKey);

        /**
         * <p>
         * The Session Token portion of the credentials
         * </p>
         * 
         * @param sessionToken
         *        The Session Token portion of the credentials
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        /**
         * <p>
         * The date at which these credentials will expire.
         * </p>
         * 
         * @param expiration
         *        The date at which these credentials will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Date expiration);
    }

    private static final class BuilderImpl implements Builder {
        private String accessKeyId;

        private String secretKey;

        private String sessionToken;

        private Date expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            setAccessKeyId(model.accessKeyId);
            setSecretKey(model.secretKey);
            setSessionToken(model.sessionToken);
            setExpiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getSecretKey() {
            return secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public final Date getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(Date expiration) {
            this.expiration = StandardMemberCopier.copy(expiration);
            return this;
        }

        public final void setExpiration(Date expiration) {
            this.expiration = StandardMemberCopier.copy(expiration);
        }

        @Override
        public Credentials build() {
            return new Credentials(this);
        }
    }
}
